<?php
// توليد التوكن وتخزينه في السيشن
if (!function_exists('csrf_token')) {
    function csrf_token() {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }
}

// توليد حقل مخفي جاهز
if (!function_exists('csrf_field')) {
    function csrf_field() {
        return '<input type="hidden" name="csrf_token" value="'.csrf_token().'">';
    }
}

// دالة التحقق الأساسية
if (!function_exists('csrf_verify')) {
    function csrf_verify() {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        // دعم كلا الاسمين: csrf_token و csrf
        $t = $_POST['csrf_token'] ?? ($_POST['csrf'] ?? '');

        if (!$t || !hash_equals(csrf_token(), $t)) {
            http_response_code(403);
            die('CSRF token mismatch');
        }
    }
}

// دالة متوافقة مع الكود القديم
if (!function_exists('csrf_check')) {
    function csrf_check() {
        return csrf_verify();
    }
}
