<?php
require_once __DIR__ . '/db.php';

if (!function_exists('ledger_post')) {
    /**
     * Post a stock movement to inventory_ledger.
     */
    function ledger_post(PDO $pdo, string $entityType, $entityId, int $issueId, int $qtyIn, int $qtyOut,
                         string $refType, int $refId, ?int $createdBy = null, ?string $note = null): int {
        if ($entityType === 'WAREHOUSE') {
            $entityId = null; // enforce policy
        }
        $st = $pdo->prepare("INSERT INTO inventory_ledger (entity_type, entity_id, issue_id, qty_in, qty_out, ref_type, ref_id, status, note, created_by, created_at)
                             VALUES (?,?,?,?,?,?,?,'POSTED',?,?,NOW())");
        $st->execute([
            $entityType,
            $entityId,
            $issueId,
            max(0, $qtyIn),
            max(0, $qtyOut),
            $refType,
            $refId,
            $note,
            $createdBy,
        ]);
        return (int)$pdo->lastInsertId();
    }
}

if (!function_exists('ledger_balance')) {
    /**
     * Current balance for entity/issue using v_inventory_balance.
     */
    function ledger_balance(PDO $pdo, string $entityType, $entityId, int $issueId): int {
        if ($entityType === 'WAREHOUSE') $entityId = null;
        $st = $pdo->prepare("SELECT COALESCE(balance_qty,0) FROM v_inventory_balance WHERE entity_type=? AND ((? IS NULL AND entity_id IS NULL) OR entity_id=?) AND issue_id=?");
        $st->execute([$entityType, $entityId, $entityId, $issueId]);
        return (int)$st->fetchColumn();
    }
}

