<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

$me = require_role(['ADMIN']);   // خليها ['ADMIN','WAREHOUSE'] لو حابب الاتنين يحذفوا
$pdo = db();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    redirect('distributors.php');
}

$pdo->beginTransaction();
try {
    // 1) حذف بنود الصرف المرتبطة بالموزع
    $sqlItems = "
      DELETE di
      FROM distributor_dispatch_items di
      JOIN distributor_dispatches d ON d.id = di.dispatch_id
      WHERE d.distributor_id = ?
    ";
    $stItems = $pdo->prepare($sqlItems);
    $stItems->execute([$id]);

    // 2) حذف أوامر الصرف للموزع
    $stDis = $pdo->prepare("DELETE FROM distributor_dispatches WHERE distributor_id = ?");
    $stDis->execute([$id]);

    // 3) حذف التسويات المرتبطة بالموزع
    $stSet = $pdo->prepare("DELETE FROM outlet_settlements WHERE distributor_id = ?");
    $stSet->execute([$id]);

    // 4) حذف المرتجعات من المخزن للموزع
    $stRet = $pdo->prepare("DELETE FROM warehouse_returns WHERE distributor_id = ?");
    $stRet->execute([$id]);

    // 5) حذف المستخدم المرتبط بالموزع
    $stUser = $pdo->prepare("DELETE FROM users WHERE distributor_id = ?");
    $stUser->execute([$id]);

    // 6) حذف الموزع نفسه
    $stDist = $pdo->prepare("DELETE FROM distributors WHERE id = ?");
    $stDist->execute([$id]);

    $pdo->commit();
} catch (Exception $e) {
    $pdo->rollBack();
    error_log("DELETE distributor error: ".$e->getMessage());
}

redirect('distributors.php');
