<?php
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

$me = require_role(['ADMIN']);
$pdo = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // إيقاف
    csrf_check();
    $id     = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $action = $_POST['action'] ?? '';
    $reason = trim($_POST['reason'] ?? '');

    if ($id > 0 && $action === 'suspend' && $reason !== '') {
        $st = $pdo->prepare("
          UPDATE distributors 
          SET suspended = 1, suspended_reason = ? 
          WHERE id = ?
        ");
        $st->execute([$reason, $id]); // [web:62]
    }
} else {
    // GET لإلغاء الإيقاف
    $id     = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $action = $_GET['action'] ?? '';

    if ($id > 0 && $action === 'resume') {
        $st = $pdo->prepare("
          UPDATE distributors 
          SET suspended = 0, suspended_reason = NULL 
          WHERE id = ?
        ");
        $st->execute([$id]);
    }
}

redirect('distributors.php');
