<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/csrf.php';

$me  = require_role(['ADMIN','DISTRIBUTOR']);
$pdo = db();

$role   = $me['role'];
$distId = (int)($me['distributor_id'] ?? 0);

$error = null;

/* معالجة POST: إضافة منفذ جديد */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $op = $_POST['op'] ?? '';

  if ($op === 'create_outlet') {
    $name      = trim($_POST['name'] ?? '');
    $deal_type = $_POST['deal_type'] ?? 'CONSIGNMENT';
    $phone     = trim($_POST['phone'] ?? '');
    $address   = trim($_POST['address'] ?? '');

    if ($name === '') {
      $error = "اسم المنفذ مطلوب.";
    } elseif (!in_array($deal_type, ['CONSIGNMENT','DIRECT_SALE'], true)) {
      $error = "نوع التعامل غير صحيح.";
    } else {
      try {
        $pdo->beginTransaction();

        // إنشاء المنفذ في outlets
        $st = $pdo->prepare("
          INSERT INTO outlets (name, default_deal_type, phone, address, active)
          VALUES (?,?,?,?,1)
        ");
        $st->execute([$name, $deal_type, $phone !== '' ? $phone : null, $address !== '' ? $address : null]);
        $newOutletId = (int)$pdo->lastInsertId();

        // لو المستخدم موزع، اربط المنفذ الجديد به
        if ($role === 'DISTRIBUTOR' && $distId > 0) {
          $st2 = $pdo->prepare("
            INSERT INTO distributor_outlets (distributor_id, outlet_id)
            VALUES (?, ?)
          ");
          $st2->execute([$distId, $newOutletId]);
        }

        $pdo->commit();
        redirect("outlets.php");
      } catch (Throwable $e) {
        $pdo->rollBack();
        $error = "حدث خطأ أثناء حفظ المنفذ: " . $e->getMessage();
      }
    }
  }
}

/* جلب المنافذ حسب الدور */
$rows = [];

if ($role === 'ADMIN') {
  // الأدمن: يشوف كل المنافذ
  $rows = $pdo->query("
    SELECT o.*
    FROM outlets o
    ORDER BY o.name
  ")->fetchAll();
} elseif ($role === 'DISTRIBUTOR') {
  // الموزع: يشوف منافذه فقط من جدول الربط
  if ($distId > 0) {
    $st = $pdo->prepare("
      SELECT o.*
      FROM distributor_outlets do
      JOIN outlets o ON o.id = do.outlet_id
      WHERE do.distributor_id = ?
      ORDER BY o.name
    ");
    $st->execute([$distId]);
    $rows = $st->fetchAll();
  } else {
    $rows = [];
  }
}

$csrf = csrf_token();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>منافذ البيع — MGZ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  *, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }
  body {
    font-family: 'Tajawal', sans-serif;
    background: #f3f4f6;
    color: #1f2937;
    min-height: 100vh;
  }

  .back-link {
    display: inline-block;
    padding: 10px 20px;
    color: #6b7280;
    text-decoration: none;
    font-size: 0.9rem;
    transition: color .2s;
  }
  .back-link:hover { color: #1d4ed8; }

  .page-header {
    background: linear-gradient(135deg, #1e3a5f 0%, #2563eb 100%);
    color: #fff;
    padding: 22px 32px;
    border-radius: 12px;
    margin: 0 20px 24px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(37,99,235,.35);
  }
  .page-header h1 {
    font-size: 1.6rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 10px;
  }
  .page-header .subtitle {
    font-size: 0.85rem;
    opacity: .8;
    margin-top: 4px;
  }

  .content { padding: 0 20px 40px; }

  .card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    margin-bottom: 24px;
    overflow: hidden;
  }
  .card-header {
    padding: 16px 24px;
    border-bottom: 1px solid #e5e7eb;
    font-size: 1rem;
    font-weight: 600;
    color: #1e3a5f;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 8px;
  }
  .card-body { padding: 24px; }

  .btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 9px 20px;
    border: none;
    border-radius: 7px;
    font-size: .9rem;
    font-weight: 600;
    cursor: pointer;
    font-family: inherit;
    transition: background .2s, transform .1s;
  }
  .btn:active { transform: scale(.97); }
  .btn-primary   { background: #2563eb; color: #fff; }
  .btn-primary:hover   { background: #1d4ed8; }

  .btn-secondary {
    background:#f3f4f6;
    color:#374151;
  }

  .table-meta {
    font-size: 0.85rem;
    color: #6b7280;
    padding: 12px 24px 0;
  }
  table {
    width: 100%;
    border-collapse: collapse;
  }
  thead th {
    background: #f1f5f9;
    color: #374151;
    font-weight: 600;
    font-size: 0.875rem;
    padding: 12px 18px;
    text-align: right;
    border-bottom: 2px solid #e5e7eb;
  }
  tbody tr {
    border-bottom: 1px solid #f3f4f6;
    transition: background .15s;
  }
  tbody tr:hover { background: #f8faff; }
  tbody td {
    padding: 13px 18px;
    font-size: 0.9rem;
    color: #374151;
    text-align: right;
  }

  .badge {
    display: inline-block;
    padding: 3px 10px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
  }
  .badge-active   { background: #d1fae5; color: #065f46; }
  .badge-inactive { background: #fee2e2; color: #991b1b; }
  .badge-consign  { background: #ede9fe; color: #4c1d95; }
  .badge-direct   { background: #dbeafe; color: #1e40af; }

  .btn-link {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    color: #2563eb;
    text-decoration: none;
    font-size: 0.85rem;
    font-weight: 500;
    padding: 4px 10px;
    border-radius: 6px;
    border: 1px solid #bfdbfe;
    background: #eff6ff;
    transition: background .2s, color .2s;
  }
  .btn-link:hover { background: #dbeafe; color: #1d4ed8; }

  .empty-state {
    text-align: center;
    padding: 50px 20px;
    color: #9ca3af;
  }
  .empty-state .icon { font-size: 2.5rem; margin-bottom: 12px; }
  .empty-state p { font-size: 0.95rem; }

  .alert-danger {
    background:#fef2f2;
    border:1px solid #fecaca;
    color:#b91c1c;
    padding:10px 14px;
    border-radius:8px;
    margin:0 20px 16px;
    font-size:.85rem;
  }

  /* مودال إضافة منفذ */
  #outletModal {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,.45);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 9999;
  }
  .modal-box {
    background:#fff;
    width:95%;
    max-width:500px;
    max-height:90vh;
    overflow:auto;
    border-radius:12px;
    box-shadow:0 10px 30px rgba(15,23,42,.4);
    padding:18px 18px 20px;
  }
  .modal-header {
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:10px;
  }
  .modal-title {
    font-size:1rem;
    font-weight:700;
    margin:0;
  }
  .modal-close {
    border:none;
    background:transparent;
    font-size:1.4rem;
    cursor:pointer;
  }
  .modal-form-group {
    display:flex;
    flex-direction:column;
    gap:6px;
    margin-bottom:10px;
  }
  .modal-form-group span {
    font-size:.8rem;
    color:#374151;
  }
  .modal-form-group input,
  .modal-form-group select,
  .modal-form-group textarea {
    width:100%;
    padding:8px 10px;
    border:1px solid #d1d5db;
    border-radius:7px;
    font-size:.9rem;
    font-family:inherit;
  }
  .modal-form-group textarea {
    min-height:70px;
    resize:vertical;
  }
  .modal-actions {
    display:flex;
    justify-content:space-between;
    gap:10px;
    flex-wrap:wrap;
    margin-top:14px;
  }

  @media (max-width: 600px) {
    .content { padding: 0 14px 30px; }
    .page-header { margin: 0 14px 20px; padding: 18px 18px; flex-direction: column; align-items: flex-start; gap: 8px; }
  }
</style>
</head>
<body>

<a class="back-link" href="../dashboard.php">→ العودة للرئيسية</a>

<div class="page-header">
  <div>
    <h1>🏪 إدارة منافذ البيع</h1>
    <div class="subtitle">
      <?= $role === 'ADMIN'
        ? 'إضافة وعرض جميع نقاط توزيع المجلات'
        : 'إضافة وعرض منافذ البيع الخاصة بك فقط' ?>
    </div>
  </div>
  <div style="font-size:2rem; opacity:.25;">🏪</div>
</div>

<?php if ($error): ?>
  <div class="alert-danger"><?= h($error) ?></div>
<?php endif; ?>

<div class="content">

  <div class="card">
    <div class="card-header">
      <span>➕ إضافة منفذ بيع جديد</span>
      <button type="button" class="btn btn-primary" onclick="openOutletModal()">➕ إضافة منفذ</button>
    </div>
  </div>

  <div class="card">
    <div class="card-header">🏪 المنافذ المسجلة</div>
    <div class="table-meta"><?= count($rows) ?> منفذ</div>

    <?php if (empty($rows)): ?>
      <div class="empty-state">
        <div class="icon">🏪</div>
        <p>
          <?= $role === 'ADMIN'
            ? 'لا توجد منافذ بيع مسجلة بعد'
            : 'لا توجد منافذ مرتبطة بك حتى الآن، قم بإضافة منفذ جديد' ?>
        </p>
      </div>
    <?php else: ?>
    <table>
      <thead>
        <tr>
          <th>ID</th>
          <th>اسم المنفذ</th>
          <th>طريقة الدفع</th>
          <th>الحالة</th>
          <th>التسعير</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $o): ?>
        <tr>
          <td><?= (int)$o['id'] ?></td>
          <td><strong><?= h($o['name']) ?></strong></td>
          <td>
            <?php if ($o['default_deal_type'] === 'CONSIGNMENT'): ?>
              <span class="badge badge-consign">أمانة</span>
            <?php else: ?>
              <span class="badge badge-direct">بيع مباشر</span>
            <?php endif; ?>
          </td>
          <td>
            <?php if (!empty($o['active'])): ?>
              <span class="badge badge-active">نشط</span>
            <?php else: ?>
              <span class="badge badge-inactive">متوقف</span>
            <?php endif; ?>
          </td>
          <td>
            <a class="btn-link" href="outlet_pricing.php?outlet_id=<?= (int)$o['id'] ?>">
              ⚙ إدارة الأسعار
            </a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <?php endif; ?>
  </div>

</div>

<!-- مودال إضافة منفذ -->
<div id="outletModal">
  <div class="modal-box">
    <div class="modal-header">
      <h2 class="modal-title">إضافة منفذ بيع جديد</h2>
      <button type="button" class="modal-close" onclick="closeOutletModal()">×</button>
    </div>

    <form method="post">
      <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
      <input type="hidden" name="op" value="create_outlet">

      <div class="modal-form-group">
        <span>اسم المنفذ (إجباري)</span>
        <input type="text" name="name" required placeholder="مثال: كشك أحمد - وسط البلد">
      </div>

      <div class="modal-form-group">
        <span>طريقة الدفع (إجباري)</span>
        <select name="deal_type" required>
          <option value="CONSIGNMENT">أمانة</option>
          <option value="DIRECT_SALE">بيع مباشر</option>
        </select>
      </div>

      <div class="modal-form-group">
        <span>رقم الموبايل (اختياري)</span>
        <input type="text" name="phone" placeholder="مثال: 0100 000 0000">
      </div>

      <div class="modal-form-group">
        <span>العنوان (اختياري)</span>
        <textarea name="address" placeholder="العنوان التفصيلي للمنفذ"></textarea>
      </div>

      <div class="modal-actions">
        <button type="submit" class="btn btn-primary" style="flex:1 1 150px;">➕ إضافة</button>
        <button type="button" class="btn btn-secondary" style="flex:1 1 120px;" onclick="closeOutletModal()">إلغاء</button>
      </div>
    </form>
  </div>
</div>

<script>
function openOutletModal() {
  document.getElementById('outletModal').style.display = 'flex';
}
function closeOutletModal() {
  document.getElementById('outletModal').style.display = 'none';
}
</script>

</body>
</html>
