<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/csrf.php';

$me  = require_role(['ADMIN','WAREHOUSE']);
$pdo = db();

$pageError   = '';
$pageSuccess = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    csrf_check();
    $op = $_POST['op'] ?? '';

    if ($op === 'create') {
        $name = trim($_POST['name'] ?? '');
        if ($name === '') {
            $pageError = 'يرجى إدخال اسم المنتج.';
        } else {
            try {
                $pdo->prepare("INSERT INTO products (name) VALUES (?)")->execute([$name]);
                $pageSuccess = 'تم إضافة المنتج بنجاح.';
            } catch (Throwable $e) {
                $pageError = 'خطأ: ' . $e->getMessage();
            }
        }
    }

    if ($op === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        try {
            /* تحقق أولاً إن مفيش إصدارات مرتبطة */
            $cnt = $pdo->prepare("SELECT COUNT(*) FROM issues WHERE product_id = ?");
            $cnt->execute([$id]);
            if ((int)$cnt->fetchColumn() > 0) {
                $pageError = 'لا يمكن حذف هذا المنتج لأنه مرتبط بإصدارات موجودة. احذف الإصدارات أولاً.';
            } else {
                $pdo->prepare("DELETE FROM products WHERE id = ?")->execute([$id]);
                $pageSuccess = 'تم حذف المنتج بنجاح.';
            }
        } catch (Throwable $e) {
            $pageError = 'خطأ أثناء الحذف: ' . $e->getMessage();
        }
    }
}

$prods = $pdo->query("
    SELECT p.*, COUNT(i.id) AS issue_count
    FROM products p
    LEFT JOIN issues i ON i.product_id = p.id
    GROUP BY p.id
    ORDER BY p.name
")->fetchAll();

$csrf = csrf_token();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>المنتجات — MGZ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<style>
*, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }
body {
    font-family: 'Tajawal', sans-serif;
    background: #f4f7f6;
    direction: rtl;
    padding: 20px;
    font-size: 14px;
}
a { color: #1a73e8; text-decoration: none; }
a:hover { text-decoration: underline; }
.back-link { margin-bottom: 14px; display: inline-block; }
.page-header {
    background: linear-gradient(135deg, #1a73e8, #0d47a1);
    color: #fff;
    padding: 18px 24px;
    border-radius: 10px;
    margin-bottom: 20px;
}
.page-header h2 { font-size: 1.2rem; font-weight: 700; }
.card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    margin-bottom: 20px;
    overflow: hidden;
}
.card-header {
    padding: 14px 20px;
    border-bottom: 1px solid #eee;
    font-weight: 700;
    background: #fafafa;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.card-body { padding: 20px; }
.form-row {
    display: flex;
    gap: 10px;
    align-items: flex-end;
}
.form-group { flex: 1; }
.form-group label {
    display: block;
    font-weight: 600;
    color: #555;
    margin-bottom: 5px;
    font-size: .85rem;
}
input[type=text] {
    width: 100%;
    padding: 8px 10px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: .9rem;
    font-family: inherit;
}
input:focus {
    outline: none;
    border-color: #1a73e8;
    box-shadow: 0 0 0 3px rgba(26,115,232,.1);
}
.btn {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    padding: 8px 18px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: .88rem;
    font-family: inherit;
    font-weight: 600;
    white-space: nowrap;
    transition: opacity .15s;
}
.btn:hover { opacity: .88; }
.btn-primary { background: #1a73e8; color: #fff; }
.btn-danger  { background: #ea4335; color: #fff; }
.btn-disabled{ background: #ccc; color: #888; cursor: not-allowed; }
.btn-sm { padding: 4px 10px; font-size: .8rem; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 10px 14px; border-bottom: 1px solid #eee; text-align: right; }
th { background: #f8f9fa; font-weight: 600; color: #555; font-size: .85rem; }
tr:last-child td { border-bottom: none; }
tbody tr:hover td { background: #fafbff; }
.alert {
    padding: 12px 16px;
    border-radius: 7px;
    margin-bottom: 16px;
    font-size: .9rem;
}
.alert-danger  { background: #fce8e6; color: #c62828; border-right: 4px solid #ea4335; }
.alert-success { background: #e6f4ea; color: #1e7e34; border-right: 4px solid #34a853; }
.empty-state { text-align: center; padding: 40px 20px; color: #aaa; }
.badge-count {
    background: #e8f0fe;
    color: #1a73e8;
    padding: 2px 10px;
    border-radius: 12px;
    font-size: .78rem;
    font-weight: 700;
}
@media (max-width: 600px) {
    .form-row { flex-direction: column; }
}
</style>
</head>
<body>

<a href="../dashboard.php" class="back-link">&#8594; العودة للرئيسية</a>

<div class="page-header">
    <h2>&#128240; إدارة المنتجات (المجلات)</h2>
</div>

<?php if ($pageError !== ''): ?>
<div class="alert alert-danger">&#9888; <?= htmlspecialchars($pageError) ?></div>
<?php endif; ?>

<?php if ($pageSuccess !== ''): ?>
<div class="alert alert-success">&#9989; <?= htmlspecialchars($pageSuccess) ?></div>
<?php endif; ?>

<!-- إضافة منتج -->
<div class="card">
    <div class="card-header">&#43; إضافة منتج جديد</div>
    <div class="card-body">
        <form method="post">
            <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
            <input type="hidden" name="op"   value="create">
            <div class="form-row">
                <div class="form-group">
                    <label>اسم المجلة / المنتج *</label>
                    <input type="text" name="name"
                           placeholder="مثال: مجلة الفيصل"
                           required autofocus>
                </div>
                <div>
                    <label>&nbsp;</label>
                    <button type="submit" class="btn btn-primary">&#10003; حفظ</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة المنتجات -->
<div class="card">
    <div class="card-header">
        قائمة المنتجات
        <span style="font-weight:400;font-size:.85rem;color:#888;"><?= count($prods) ?> منتج</span>
    </div>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>اسم المنتج</th>
                <th>عدد الإصدارات</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody>
        <?php if (empty($prods)): ?>
            <tr><td colspan="4">
                <div class="empty-state">
                    لا توجد منتجات بعد — أضف منتجاً من الأعلى
                </div>
            </td></tr>
        <?php else: ?>
            <?php foreach ($prods as $idx => $p): ?>
            <tr>
                <td><?= $idx + 1 ?></td>
                <td><strong><?= h($p['name']) ?></strong></td>
                <td>
                    <span class="badge-count"><?= (int)$p['issue_count'] ?> إصدار</span>
                </td>
                <td>
                    <?php if ((int)$p['issue_count'] > 0): ?>
                        <button class="btn btn-disabled btn-sm" disabled
                                title="لا يمكن الحذف — يوجد إصدارات مرتبطة">
                            &#128465; لا يمكن الحذف
                        </button>
                    <?php else: ?>
                        <form method="post" style="display:inline"
                              onsubmit="return confirm('حذف المنتج نهائياً؟')">
                            <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
                            <input type="hidden" name="op"   value="delete">
                            <input type="hidden" name="id"   value="<?= (int)$p['id'] ?>">
                            <button type="submit" class="btn btn-danger btn-sm">
                                &#128465; حذف
                            </button>
                        </form>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

</body>
</html>
