<?php
// IMPORTANT: إن أمكن ضع بيانات الاتصال في ملف .env خارج public_html.
// هذا الملف موجود للتشغيل السريع وللتوافق مع النسخ السابقة.
return [
  'db' => [
    'host' => getenv('DB_HOST') ?: 'localhost',
    'name' => getenv('DB_NAME') ?: 'hshtpbxs_mgz970',
    'user' => getenv('DB_USER') ?: 'hshtpbxs_mgz970',
    // SECURITY: never ship a default password in the repo.
    // Set DB_PASS in .env / environment variables.
    'pass' => (function() {
      $p = getenv('DB_PASS');
      if ($p === false || $p === '') {
        throw new RuntimeException('Missing DB_PASS. Please set it in .env or environment variables.');
      }
      return $p;
    })(),
    'charset' => 'utf8mb4',
  ],
  'app' => [
    'base_url' => getenv('BASE_URL') ?: '/mgz',
    'timezone' => getenv('APP_TZ') ?: 'Asia/Muscat',
  ],
  'uploads' => [
    // يمكن نقلها خارج الويب (مفضل). الافتراضي خارج مجلد mgz إن أمكن.
    'dir' => getenv('UPLOADS_DIR') ?: (__DIR__ . '/../uploads'),
    'max_bytes' => (int)(getenv('UPLOADS_MAX') ?: (8 * 1024 * 1024)),
    'allowed_mimes' => [
      'image/jpeg','image/png','application/pdf'
    ],
  ],
];
