<?php
// توليد التوكن وتخزينه في السيشن
if (!function_exists('csrf_token')) {
    function csrf_token() {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }
}

// توليد حقل مخفي جاهز
if (!function_exists('csrf_field')) {
    function csrf_field() {
        return '<input type="hidden" name="csrf_token" value="'.csrf_token().'">';
    }
}

// دالة التحقق الأساسية
if (!function_exists('csrf_verify')) {
    function csrf_verify() {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        // دعم كلا الاسمين: csrf_token و csrf
        $t = $_POST['csrf_token'] ?? ($_POST['csrf'] ?? '');

        if (!$t || !hash_equals(csrf_token(), $t)) {
            http_response_code(403);
            die('CSRF token mismatch');
        }
    }
}

// دالة متوافقة مع الكود القديم
if (!function_exists('csrf_check')) {
    function csrf_check() {
        return csrf_verify();
    }
}



// One-time form token to prevent double submit
// NOTE: must support multiple forms per page, so we store many tokens per key.
if (!function_exists('form_token')) {
    function form_token(string $key='default'): string {
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        if (!isset($_SESSION['form_tokens'])) $_SESSION['form_tokens'] = [];
        if (!isset($_SESSION['form_tokens'][$key]) || !is_array($_SESSION['form_tokens'][$key])) {
            $_SESSION['form_tokens'][$key] = [];
        }

        $t = bin2hex(random_bytes(16));
        $_SESSION['form_tokens'][$key][$t] = time();

        // keep only the most recent 200 tokens per key
        if (count($_SESSION['form_tokens'][$key]) > 200) {
            asort($_SESSION['form_tokens'][$key]);
            $_SESSION['form_tokens'][$key] = array_slice($_SESSION['form_tokens'][$key], -200, null, true);
        }
        return $t;
    }
}

if (!function_exists('consume_form_token')) {
    function consume_form_token(string $key='default', ?string $token=null): bool {
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        $token = $token ?? ($_POST['form_token'] ?? null);
        if (!$token) return false;

        $bucket = $_SESSION['form_tokens'][$key] ?? null;
        if (!is_array($bucket) || !isset($bucket[$token])) return false;

        unset($_SESSION['form_tokens'][$key][$token]);
        return true;
    }
}
