<?php
/**
 * Minimal .env loader (KEY=VALUE) with comments (#) and quoted values.
 * Compatible with PHP 7+ (includes small polyfills for str_starts_with/str_ends_with).
 */
if (!function_exists('str_starts_with')) {
  function str_starts_with($haystack, $needle) {
    return $needle === '' || strpos($haystack, $needle) === 0;
  }
}
if (!function_exists('str_ends_with')) {
  function str_ends_with($haystack, $needle) {
    if ($needle === '') return true;
    $len = strlen($needle);
    return substr($haystack, -$len) === $needle;
  }
}

function mgz_load_env_once(): void {
  static $loaded = false;
  if ($loaded) return;
  $loaded = true;

  $candidates = [
    __DIR__ . '/../.env',
    __DIR__ . '/../config/.env',
    __DIR__ . '/../../.env',
    __DIR__ . '/../../config/.env',
  ];

  foreach ($candidates as $file) {
    if (!is_readable($file)) continue;
    $lines = file($file, FILE_IGNORE_NEW_LINES);
    if (!$lines) continue;

    foreach ($lines as $line) {
      $line = trim($line);
      if ($line === '' || str_starts_with($line, '#')) continue;
      $pos = strpos($line, '=');
      if ($pos === false) continue;

      $key = trim(substr($line, 0, $pos));
      $val = trim(substr($line, $pos + 1));

      if ((str_starts_with($val, '"') && str_ends_with($val, '"')) ||
          (str_starts_with($val, "'") && str_ends_with($val, "'"))) {
        $val = substr($val, 1, -1);
      }

      if ($key !== '' && getenv($key) === false) {
        putenv($key . '=' . $val);
        $_ENV[$key] = $val;
      }
    }
  }
}
