<?php
function mgz_log(string $level, string $message, array $context = []): void {
  $dir = getenv('APP_LOG_DIR') ?: (__DIR__ . '/../logs');

  // Try to create logs directory
  if (!is_dir($dir)) {
    @mkdir($dir, 0755, true);
  }

  $ts = date('Y-m-d H:i:s');
  $ctx = $context ? json_encode($context, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) : '';
  $line = "[$ts] [$level] $message" . ($ctx ? " $ctx" : "");

  $file = rtrim($dir, '/\\') . DIRECTORY_SEPARATOR . 'app.log';

  // Primary write
  $ok = false;
  if (is_dir($dir) && is_writable($dir)) {
    $ok = @file_put_contents($file, $line . PHP_EOL, FILE_APPEND) !== false;
  }

  // Fallback: system error_log (server logs)
  if (!$ok) {
    error_log("MGZ $line");
  }
}
