(function(){
  function makeTablesResponsive(){
    document.querySelectorAll('table').forEach(function(tbl){
      if (!tbl.querySelector('thead')) return;
      // mark as responsive unless explicitly opted out
      if (!tbl.classList.contains('no-responsive')) tbl.classList.add('responsive');
      var headers=[];
      tbl.querySelectorAll('thead th').forEach(function(th){
        headers.push((th.textContent||'').trim());
      });
      if (!headers.length) return;
      tbl.querySelectorAll('tbody tr').forEach(function(tr){
        var tds = tr.querySelectorAll('td');
        tds.forEach(function(td, i){
          if (!td.getAttribute('data-label')){
            td.setAttribute('data-label', headers[i] || '');
          }
        });
      });
    });
  }
  document.addEventListener('DOMContentLoaded', makeTablesResponsive);
})();
