<?php
require_once __DIR__ . '/app/auth.php';
require_once __DIR__ . '/app/db.php';
require_once __DIR__ . '/app/security.php';

auth_start();
$u = auth_user();
if (!$u) { header("Location: login.php"); exit; }

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { http_response_code(400); echo "Bad request"; exit; }

$cfg = require __DIR__ . '/app/config.php';
$uploadsRoot = $cfg['uploads']['dir'] ?? (__DIR__ . '/../uploads');
$uploadsRootReal = realpath($uploadsRoot) ?: $uploadsRoot;

$pdo = db();
$st = $pdo->prepare("SELECT * FROM attachments WHERE id=?");
$st->execute([$id]);
$a = $st->fetch(PDO::FETCH_ASSOC);
if (!$a) { http_response_code(404); echo "Not found"; exit; }

// CHANGE START: RBAC / ownership checks for attachments (prevent IDOR)
// Rule summary:
// - ADMIN: can download all.
// - WAREHOUSE: can download warehouse documents and shared docs.
// - DISTRIBUTOR: only attachments belonging to their distributor.

$role = (string)($u['role'] ?? '');
$myDistributorId = (int)($u['distributor_id'] ?? 0);

if ($role !== 'ADMIN') {
  $attDistributorId = isset($a['distributor_id']) ? (int)$a['distributor_id'] : 0;
  $attEntityType = (string)($a['entity_type'] ?? '');
  $attEntityId = isset($a['entity_id']) ? (int)$a['entity_id'] : 0;

  $allowed = false;

  if ($role === 'DISTRIBUTOR') {
    if ($attDistributorId > 0) {
      $allowed = ($attDistributorId === $myDistributorId);
    } else {
      // Fallback: infer distributor ownership from referencing documents.
      if ($attEntityType === 'OUTLET_DELIVERY' && $attEntityId > 0) {
        $st2 = $pdo->prepare("SELECT distributor_id FROM outlet_deliveries WHERE id=? LIMIT 1");
        $st2->execute([$attEntityId]);
        $allowed = ((int)$st2->fetchColumn() === $myDistributorId);
      } elseif ($attEntityType === 'DISPATCH' && $attEntityId > 0) {
        $st2 = $pdo->prepare("SELECT distributor_id FROM distributor_dispatches WHERE id=? LIMIT 1");
        $st2->execute([$attEntityId]);
        $allowed = ((int)$st2->fetchColumn() === $myDistributorId);
      } elseif ($attEntityType === 'WH_RETURN' && $attEntityId > 0) {
        $st2 = $pdo->prepare("SELECT distributor_id FROM warehouse_returns WHERE id=? LIMIT 1");
        $st2->execute([$attEntityId]);
        $allowed = ((int)$st2->fetchColumn() === $myDistributorId);
      } elseif ($attEntityType === 'DAMAGE_REPORT' && $attEntityId > 0) {
        $st2 = $pdo->prepare("SELECT distributor_id FROM damage_reports WHERE id=? LIMIT 1");
        $st2->execute([$attEntityId]);
        $allowed = ((int)$st2->fetchColumn() === $myDistributorId);
      }
    }
  } elseif ($role === 'WAREHOUSE') {
    // Warehouse can access warehouse-scoped docs and shared docs.
    // If an attachment is explicitly assigned to a distributor, keep it private.
    if ($attDistributorId > 0) {
      $allowed = false;
    } else {
      $allowed = true;
    }
  }

  if (!$allowed) {
    http_response_code(403);
    echo "Forbidden";
    exit;
  }
}
// CHANGE END

$path = (string)($a['path'] ?? '');
$filename = (string)($a['filename'] ?? 'file');
$mime = (string)($a['mime'] ?? 'application/octet-stream');

$fs = null;

// New format: path is relative to uploads root (e.g. "attachments/abc.pdf")
if ($path && !preg_match('~^https?://~i', $path) && !str_contains($path, '/uploads/')) {
  $candidate = $uploadsRootReal . DIRECTORY_SEPARATOR . ltrim($path, '/\\');
  $real = realpath($candidate);
  if ($real && str_starts_with($real, $uploadsRootReal)) $fs = $real;
}

// Legacy format: stored URL like "/mgz/uploads/.."
if (!$fs && $path && str_contains($path, '/uploads/')) {
  $pos = strpos($path, '/uploads/');
  $rel = substr($path, $pos + strlen('/uploads/'));
  $candidate = __DIR__ . '/uploads/' . $rel; // legacy public folder
  $real = realpath($candidate);
  if ($real) $fs = $real;
}

if (!$fs || !is_file($fs)) { http_response_code(404); echo "File missing"; exit; }

header('Content-Type: ' . $mime);
header('Content-Length: ' . filesize($fs));
header('Content-Disposition: inline; filename="' . basename($filename) . '"');
header('X-Content-Type-Options: nosniff');

readfile($fs);
exit;
