<?php
require_once __DIR__ . '/app/db.php';
require_once __DIR__ . '/app/auth.php';
require_once __DIR__ . '/app/helpers.php';
require_once __DIR__ . '/app/login_throttle.php';

auth_start();

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim($_POST['username'] ?? '');
  $pass     = $_POST['password'] ?? '';

  $pdo = db();

  // CHANGE START: brute-force protection
  $ip = mgz_client_ip();
  $lock = mgz_login_is_locked($pdo, $username, $ip);
  if (!empty($lock['locked'])) {
    $error = "محاولات كثيرة. حاول مرة أخرى لاحقاً.";
  } else {
  // CHANGE END
  // إضافة distributor_id في الـ SELECT
  $st = $pdo->prepare("
    SELECT id, name, username, role, password_hash, is_active, distributor_id
    FROM users
    WHERE username = ?
    LIMIT 1
  ");
  $st->execute([$username]);
  $u = $st->fetch();

  $ok = (
    !$u ||
    !(int)$u['is_active'] ||
    !password_verify($pass, $u['password_hash'])
  ) ? false : true;

  // CHANGE START: log attempt
  mgz_login_log_attempt($pdo, $username, $ip, $ok);
  // CHANGE END

  if (!$ok) {
    $error = "بيانات الدخول غير صحيحة";
  } else {
    session_regenerate_id(true);
    // تخزين distributor_id في السيشن عشان تستخدمه outlet_deliveries.php
    $_SESSION['user'] = [
      'id'             => (int)$u['id'],
      'name'           => $u['name'],
      'role'           => $u['role'],
      'distributor_id' => $u['distributor_id'], // مهم لحساب الموزع
    ];
    header("Location: dashboard.php");
    exit;
  }
  }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>تسجيل الدخول - نظام إدارة المجلات</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
<style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f4f7f6;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
    }
    .login-box {
      background: #fff;
      padding: 2rem;
      border-radius: 8px;
      box-shadow: 0 4px 6px rgba(0,0,0,0.1);
      width: 100%;
      max-width: 400px;
    }
    h3 {
      text-align: center;
      color: #333;
      margin-top: 0;
    }
    input {
      width: 100%;
      padding: 10px;
      margin: 10px 0;
      border: 1px solid #ddd;
      border-radius: 4px;
      box-sizing: border-box;
      font-size: 14px;
    }
    button {
      width: 100%;
      padding: 10px;
      background: #2c3e50;
      color: #fff;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 16px;
    }
    button:hover {
      background: #34495e;
    }
    .error {
      color: #e74c3c;
      text-align: center;
      margin-bottom: 1rem;
      font-size: 14px;
    }
    label {
      font-size: 14px;
      color: #555;
    }
  </style>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/ui.css">
<script defer src="assets/ui.js"></script>
</head>
<body>
  <div class="login-box">
    <h3>تسجيل الدخول</h3>
    <?php if ($error): ?>
      <div class="error"><?= h($error) ?></div>
    <?php endif; ?>
    <form method="post">
      <label>اسم المستخدم</label>
      <input name="username" required autofocus>
      <label>كلمة المرور</label>
      <input name="password" type="password" required>
      <button type="submit">دخول</button>
    </form>
  </div>
</body>
</html>
