-- MGZ Patch: security + integrity
-- Apply on existing DB (MySQL/MariaDB).

START TRANSACTION;

-- 1) Attachments: add ownership / entity linkage for RBAC downloads
ALTER TABLE attachments
  ADD COLUMN entity_type VARCHAR(40) NULL AFTER original_name,
  ADD COLUMN entity_id BIGINT(20) UNSIGNED NULL AFTER entity_type,
  ADD COLUMN distributor_id BIGINT(20) UNSIGNED NULL AFTER entity_id,
  ADD COLUMN outlet_id BIGINT(20) UNSIGNED NULL AFTER distributor_id,
  ADD KEY ix_att_entity (entity_type, entity_id),
  ADD KEY ix_att_distributor (distributor_id),
  ADD KEY ix_att_outlet (outlet_id);

-- 2) Uniques to prevent duplicate documents / allocations
ALTER TABLE outlet_settlements
  ADD UNIQUE KEY uk_outlet_settlement_delivery (delivery_id);

ALTER TABLE invoices
  ADD UNIQUE KEY uk_invoice_source (source_type, source_id);

ALTER TABLE payment_allocations
  ADD UNIQUE KEY uk_payment_invoice (payment_id, invoice_id);

-- 3) Brute force protection tables
CREATE TABLE IF NOT EXISTS login_attempt_logs (
  id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  username VARCHAR(190) NOT NULL,
  ip VARCHAR(64) NOT NULL,
  success TINYINT(1) NOT NULL DEFAULT 0,
  attempted_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY ix_login_logs_user_ip_time (username, ip, attempted_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS login_attempts (
  username VARCHAR(190) NOT NULL,
  ip VARCHAR(64) NOT NULL,
  locked_until DATETIME NOT NULL,
  PRIMARY KEY (username, ip)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 4) Optional: add attachment id to damage_reports for future normalization
ALTER TABLE damage_reports
  ADD COLUMN photo_attachment_id BIGINT(20) UNSIGNED NULL AFTER photo_path,
  ADD KEY ix_damage_photo_att (photo_attachment_id);

-- 5) Backfill attachments ownership where possible (existing data)
-- Dispatch POD
UPDATE attachments a
JOIN distributor_dispatches d ON d.pod_attachment_id = a.id
SET a.entity_type='DISPATCH', a.entity_id=d.id, a.distributor_id=d.distributor_id
WHERE a.entity_type IS NULL;

-- Warehouse return POD
UPDATE attachments a
JOIN warehouse_returns wr ON wr.pod_attachment_id = a.id
SET a.entity_type='WH_RETURN', a.entity_id=wr.id, a.distributor_id=wr.distributor_id
WHERE a.entity_type IS NULL;

-- Outlet delivery POD
UPDATE attachments a
JOIN outlet_deliveries od ON od.pod_attachment_id = a.id
SET a.entity_type='OUTLET_DELIVERY', a.entity_id=od.id, a.distributor_id=od.distributor_id, a.outlet_id=od.outlet_id
WHERE a.entity_type IS NULL;

-- Warehouse receipt POD/image
UPDATE attachments a
JOIN warehouse_receipts w ON w.pod_attachment_id = a.id
SET a.entity_type='WH_RECEIPT', a.entity_id=w.id
WHERE a.entity_type IS NULL;

COMMIT;
