<?php
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

$me = require_role(['ADMIN']);
$pdo = db();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  redirect('distributors.php');
}

$error = null;

// جلب بيانات الموزع
$st = $pdo->prepare("SELECT * FROM distributors WHERE id = ?");
$st->execute([$id]);
$dist = $st->fetch();

if (!$dist) {
  redirect('distributors.php');
}

// جلب بيانات اليوزر المرتبط (اختياري)
$st2 = $pdo->prepare("SELECT * FROM users WHERE distributor_id = ?");
$st2->execute([$id]);
$user = $st2->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $name   = trim($_POST['name'] ?? '');
  $type   = $_POST['comm_type'] ?? 'PERCENT';
  $val    = (float)($_POST['comm_val'] ?? 0);
  $active = isset($_POST['active']) ? 1 : 0;

  $email = trim($_POST['email'] ?? '');
  $phone = trim($_POST['phone'] ?? '');

  if ($name === '') {
    $error = 'اسم الموزع مطلوب.';
  } else {
    $pdo->beginTransaction();
    try {
      // تحديث الموزع
      $st = $pdo->prepare("
        UPDATE distributors 
        SET name = ?, commission_type = ?, commission_value = ?, active = ?
        WHERE id = ?
      ");
      $st->execute([$name, $type, $val, $active, $id]);

      // تحديث بيانات التواصل في users لو فيه يوزر
      if ($user) {
        $st2 = $pdo->prepare("
          UPDATE users 
          SET name = ?, email = ?, phone = ?
          WHERE distributor_id = ?
        ");
        $st2->execute([
          $name,
          $email !== '' ? $email : null,
          $phone !== '' ? $phone : null,
          $id
        ]);
      }

      $pdo->commit();
      redirect('distributors.php');
    } catch (Exception $e) {
      $pdo->rollBack();
      $error = 'حدث خطأ أثناء التعديل.';
    }
  }
}

$csrf = csrf_token();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>تعديل موزع — MGZ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<style>
  body { font-family: 'Tajawal', sans-serif; background:#f3f4f6; padding:20px; }
  .card { max-width: 700px; margin:0 auto; background:#fff; padding:20px 24px; border-radius:10px; box-shadow:0 2px 8px rgba(0,0,0,.08); }
  h1 { font-size:1.3rem; margin-bottom:15px; }
  label { display:block; margin-bottom:10px; font-size:0.85rem; color:#4b5563; }
  input, select { width:100%; padding:8px 10px; border-radius:6px; border:1px solid #d1d5db; margin-top:4px; box-sizing:border-box; }
  .row { display:flex; gap:12px; }
  .row > div { flex:1; }
  .btn { background:#2563eb; color:#fff; border:none; padding:9px 18px; border-radius:7px; cursor:pointer; margin-top:10px; }
  .btn-cancel { background:#6b7280; text-decoration:none; display:inline-block; padding:9px 18px; border-radius:7px; color:#fff; margin-right:8px; }
  .error { background:#fee2e2; color:#991b1b; padding:8px 12px; border-radius:8px; margin-bottom:10px; font-size:0.9rem; }
</style>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="../assets/ui.css">
<script defer src="../assets/ui.js"></script>
</head>
<body>

<div class="card">
  <h1>تعديل بيانات الموزع</h1>

  <?php if ($error): ?>
    <div class="error"><?= h($error) ?></div>
  <?php endif; ?>

  <form method="post">
    <input type="hidden" name="csrf" value="<?= h($csrf) ?>">

    <label>
      اسم الموزع
      <input type="text" name="name" value="<?= h($dist['name']) ?>" required>
    </label>

    <div class="row">
      <div>
        <label>
          نوع العمولة
          <select name="comm_type">
            <option value="PERCENT" <?= $dist['commission_type']==='PERCENT'?'selected':'' ?>>نسبة مئوية</option>
            <option value="PER_COPY" <?= $dist['commission_type']==='PER_COPY'?'selected':'' ?>>مبلغ لكل نسخة</option>
            <option value="NONE"    <?= $dist['commission_type']==='NONE'?'selected':'' ?>>بدون عمولة</option>
          </select>
        </label>
      </div>
      <div>
        <label>
          قيمة العمولة
          <input type="number" step="0.001" min="0" name="comm_val" value="<?= h($dist['commission_value']) ?>">
        </label>
      </div>
    </div>

    <label>
      <input type="checkbox" name="active" value="1" <?= $dist['active'] ? 'checked' : '' ?>>
      الموزع نشط
    </label>

    <?php if ($user): ?>
      <hr style="margin:15px 0;">
      <h3 style="font-size:1rem; margin-bottom:10px;">بيانات التواصل للمستخدم المرتبط</h3>

      <div class="row">
        <div>
          <label>
            البريد الإلكتروني
            <input type="email" name="email" value="<?= h($user['email'] ?? '') ?>">
          </label>
        </div>
        <div>
          <label>
            رقم الهاتف
            <input type="text" name="phone" value="<?= h($user['phone'] ?? '') ?>">
          </label>
        </div>
      </div>
    <?php endif; ?>

    <button type="submit" class="btn">حفظ التعديلات</button>
    <a href="distributors.php" class="btn-cancel">إلغاء</a>
  </form>
</div>

</body>
</html>
