<?php
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';
require_once __DIR__ . '/../app/csrf.php';

$me = require_role(['ADMIN']);
$pdo = db();

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  // بيانات الموزع
  $name = trim($_POST['name'] ?? '');
  $type = $_POST['comm_type'] ?? 'PERCENT';
  $val  = (float)($_POST['comm_val'] ?? 0);

  // بيانات اليوزر
  $username = trim($_POST['username'] ?? '');
  $email    = trim($_POST['email'] ?? '');
  $phone    = trim($_POST['phone'] ?? '');
  $password = $_POST['password'] ?? '';

  if ($name === '' || $username === '' || $password === '') {
    $error = 'اسم الموزع، واسم المستخدم، وكلمة المرور مطلوبة.';
  } else {
    // تأكد أن اليوزر نيم مش مكرر
    $st = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $st->execute([$username]);
    if ($st->fetch()) {
      $error = 'اسم المستخدم مستخدم من قبل، اختر اسم آخر.';
    } else {
      $pdo->beginTransaction();
      try {
        // 1) إضافة الموزع في distributors
        $st = $pdo->prepare("
          INSERT INTO distributors (name, commission_type, commission_value, active, suspended, suspended_reason) 
          VALUES (?,?,?,1,0,NULL)
        ");
        $st->execute([$name, $type, $val]);
        $distributorId = $pdo->lastInsertId();

        // 2) تشفير كلمة المرور
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);

        // 3) إنشاء يوزر مربوط بالموزع في users
        $st2 = $pdo->prepare("
          INSERT INTO users (name, username, email, phone, password_hash, role, distributor_id, is_active)
          VALUES (?,?,?,?,?,'DISTRIBUTOR',?,1)
        ");
        $st2->execute([
          $name,
          $username,
          $email !== '' ? $email : null,
          $phone  !== '' ? $phone  : null,
          $passwordHash,
          $distributorId
        ]);

        $pdo->commit();
        redirect("distributors.php");
      } catch (Exception $e) {
        $pdo->rollBack();
        $error = 'حدث خطأ أثناء الحفظ، حاول مرة أخرى.';
      }
    }
  }
}

$rows = $pdo->query("SELECT d.*,  (SELECT COALESCE(SUM(balance_due),0) FROM invoices i WHERE i.distributor_id=d.id AND i.status IN ('ISSUED','PARTIAL') AND i.balance_due>0) AS due_amount, (SELECT COUNT(*) FROM payments p WHERE p.distributor_id=d.id AND p.status='HELD') AS held_payments FROM distributors d ORDER BY d.name")->fetchAll();
$csrf = csrf_token();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>الموزعون — MGZ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<style>
  *, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }
  body {
    font-family: 'Tajawal', sans-serif;
    background: #f3f4f6;
    color: #1f2937;
    min-height: 100vh;
  }

  .back-link {
    display: inline-block;
    padding: 10px 20px;
    color: #6b7280;
    text-decoration: none;
    font-size: 0.9rem;
    transition: color .2s;
  }
  .back-link:hover { color: #1d4ed8; }

  .page-header {
    background: linear-gradient(135deg, #1e3a5f 0%, #2563eb 100%);
    color: #fff;
    padding: 22px 32px;
    border-radius: 12px;
    margin: 0 20px 24px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 4px 15px rgba(37,99,235,.35);
  }
  .page-header h1 {
    font-size: 1.6rem;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 10px;
  }
  .page-header .subtitle {
    font-size: 0.85rem;
    opacity: .8;
    margin-top: 4px;
  }

  .content { padding: 0 20px 40px; }

  .card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    margin-bottom: 24px;
    overflow: hidden;
  }
  .card-header {
    padding: 16px 24px;
    border-bottom: 1px solid #e5e7eb;
    font-size: 1rem;
    font-weight: 600;
    color: #1e3a5f;
    display: flex;
    align-items: center;
    gap: 8px;
  }
  .card-body { padding: 24px; }

  .form-row {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    flex-wrap: wrap;
  }
  .form-row input[type="text"],
  .form-row input[type="number"],
  .form-row input[type="password"],
  .form-row input[type="email"],
  .form-row select {
    padding: 9px 14px;
    border: 1px solid #d1d5db;
    border-radius: 7px;
    font-size: 0.95rem;
    font-family: inherit;
    background: #f9fafb;
    color: #1f2937;
    transition: border-color .2s, box-shadow .2s;
    outline: none;
  }
  .form-row input[type="text"],
  .form-row input[type="email"],
  .form-row input[type="password"] { width: 200px; }
  .form-row input[type="number"] { width: 130px; }
  .form-row input:focus,
  .form-row select:focus {
    border-color: #2563eb;
    box-shadow: 0 0 0 3px rgba(37,99,235,.15);
    background: #fff;
  }
  .form-row label {
    font-size: 0.82rem;
    color: #6b7280;
    display: flex;
    flex-direction: column;
    gap: 4px;
  }
  .btn-add {
    background: #2563eb;
    color: #fff;
    border: none;
    padding: 9px 22px;
    border-radius: 7px;
    font-size: 0.95rem;
    font-weight: 600;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: background .2s, transform .1s;
    align-self: flex-end;
  }
  .btn-add:hover  { background: #1d4ed8; }
  .btn-add:active { transform: scale(.98); }

  .error-msg {
    background: #fee2e2;
    color: #991b1b;
    padding: 10px 15px;
    border-radius: 8px;
    margin-bottom: 10px;
    font-size: 0.9rem;
  }

  .table-meta {
    font-size: 0.85rem;
    color: #6b7280;
    padding: 12px 24px 0;
  }
  table { width: 100%; border-collapse: collapse; }
  thead th {
    background: #f1f5f9;
    color: #374151;
    font-weight: 600;
    font-size: 0.875rem;
    padding: 12px 18px;
    text-align: right;
    border-bottom: 2px solid #e5e7eb;
  }
  tbody tr {
    border-bottom: 1px solid #f3f4f6;
    transition: background .15s;
  }
  tbody tr:hover  { background: #f8faff; }
  tbody tr:last-child { border-bottom: none; }
  tbody td {
    padding: 13px 18px;
    font-size: 0.9rem;
    color: #374151;
    text-align: right;
  }

  .badge {
    display: inline-block;
    padding: 3px 11px;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
  }
  .badge-active    { background: #d1fae5; color: #065f46; }
  .badge-inactive  { background: #fee2e2; color: #991b1b; }
  .badge-percent   { background: #ede9fe; color: #4c1d95; }
  .badge-per-copy  { background: #dbeafe; color: #1e40af; }
  .badge-none      { background: #f3f4f6; color: #6b7280; }

  .comm-value {
    font-weight: 700;
    color: #1e3a5f;
  }
  .comm-unit {
    font-size: 0.78rem;
    color: #6b7280;
    margin-right: 3px;
  }

  .empty-state {
    text-align: center;
    padding: 50px 20px;
    color: #9ca3af;
  }
  .empty-state .icon { font-size: 2.5rem; margin-bottom: 12px; }
  .empty-state p { font-size: 0.95rem; }

  /* مودال إضافة موزع جديد */
  .modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,.45);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 10000;
  }
  .modal-dialog {
    background: #fff;
    border-radius: 12px;
    width: 95%;
    max-width: 520px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: 0 10px 30px rgba(0,0,0,.25);
    padding: 18px 20px 20px;
  }
  .modal-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    font-size: 1rem;
    font-weight: 600;
    color: #1e3a5f;
    margin-bottom: 12px;
  }
  .modal-close {
    background: transparent;
    border: none;
    font-size: 1rem;
    cursor: pointer;
    color: #6b7280;
  }
  .modal-close:hover {
    color: #ef4444;
  }
  .modal-body {
    font-size: 0.9rem;
  }

  @media (max-width: 480px) {
    .modal-dialog {
      width: 100%;
      height: 100%;
      max-width: 100%;
      max-height: 100%;
      border-radius: 0;
    }
  }
</style>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="../assets/ui.css">
<script defer src="../assets/ui.js"></script>
</head>
<body>

<a class="back-link" href="../dashboard.php">→ العودة للرئيسية</a>

<div class="page-header">
  <div>
    <h1>🚚 إدارة الموزعين</h1>
    <div class="subtitle">إضافة وعرض موزعي المجلات وعمولاتهم وحسابات الدخول والإيقاف الإداري</div>
  </div>
  <div style="font-size:2.2rem; opacity:.2;">🚚</div>
</div>

<div class="content">

  <!-- زر فتح المودال فقط -->
  <button class="btn-add" onclick="openAddModal()">
    ➕ إضافة موزع جديد
  </button>

  <!-- كارت جدول الموزعين كما هو -->
  <div class="card" style="margin-top:20px;">
    <div class="card-header">🚚 قائمة الموزعين</div>
    <div class="table-meta"><?= count($rows) ?> موزع</div>

    <?php if (empty($rows)): ?>
      <div class="empty-state">
        <div class="icon">🚚</div>
        <p>لا يوجد موزعون مسجلون بعد</p>
      </div>
    <?php else: ?>
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>اسم الموزع</th>
          <th>نوع العمولة</th>
          <th>قيمة العمولة</th>
          <th>مديونيات</th>
          <th>الحالة</th>
          <th>الإيقاف الإداري</th>
          <th>إجراءات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $i => $r): ?>
        <tr>
          <td><?= $i + 1 ?></td>
          <td><strong><?= h($r['name']) ?></strong></td>
          <td>
            <?php if ($r['commission_type'] === 'PERCENT'): ?>
              <span class="badge badge-percent">نسبة مئوية</span>
            <?php elseif ($r['commission_type'] === 'PER_COPY'): ?>
              <span class="badge badge-per-copy">لكل نسخة</span>
            <?php else: ?>
              <span class="badge badge-none">بدون عمولة</span>
            <?php endif; ?>
          </td>
          <td>
            <?php if ($r['commission_type'] !== 'NONE'): ?>
              <span class="comm-value"><?= omr((float)$r['commission_value']) ?></span>
              <?php if ($r['commission_type'] === 'PERCENT'): ?>
                <span class="comm-unit">%</span>
              <?php else: ?>
                <span class="comm-unit">ر.ع. / نسخة</span>
              <?php endif; ?>
            <?php else: ?>
              <span style="color:#9ca3af;">—</span>
            <?php endif; ?>
          </td>
          <td>
            <?php $due=(float)($r['due_amount'] ?? 0); $held=(int)($r['held_payments'] ?? 0); ?>
            <span class="money"><?= omr($due) ?></span>
            <?php if($held>0): ?><div class="muted" style="font-size:12px;">تحصيلات معلّقة: <?= (int)$held ?></div><?php endif; ?>
          </td>
          <td>
            <?php if ($r['active']): ?>
              <span class="badge badge-active">نشط</span>
            <?php else: ?>
              <span class="badge badge-inactive">متوقف</span>
            <?php endif; ?>
          </td>

          <td>
            <?php if (!empty($r['suspended']) && $r['suspended']): ?>
              <span class="badge badge-inactive" title="<?= h($r['suspended_reason'] ?? '') ?>">
                موقوف
              </span>
            <?php else: ?>
              <span class="badge badge-active">مسموح</span>
            <?php endif; ?>
          </td>

          <td>
            <a href="distributor_edit.php?id=<?= (int)$r['id'] ?>" style="color:#2563eb; text-decoration:none; margin-left:8px;">
              ✏️ تعديل
            </a>

            <?php if (empty($r['suspended']) || !$r['suspended']): ?>
              <a href="#"
                 onclick="openSuspendModal(<?= (int)$r['id'] ?>); return false;"
                 style="color:#b45309; text-decoration:none; margin-left:8px;">
                ⛔ إيقاف
              </a>
            <?php else: ?>
              <!-- CHANGE START: resume via POST + CSRF -->
              <form method="post" action="distributor_suspend_toggle.php" style="display:inline;">
                <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <input type="hidden" name="action" value="resume">
                <button type="submit" style="background:none;border:none;padding:0;color:#16a34a;cursor:pointer;text-decoration:none;margin-left:8px;">
                  ✅ إلغاء الإيقاف
                </button>
              </form>
              <!-- CHANGE END -->
            <?php endif; ?>

            <!-- CHANGE START: delete via POST + CSRF -->
            <form method="post" action="distributor_delete.php" style="display:inline;" onsubmit="return confirm('هل أنت متأكد من حذف هذا الموزع؟');">
              <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
              <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
              <button type="submit" style="background:none;border:none;padding:0;color:#b91c1c;cursor:pointer;text-decoration:none;" <?= ((float)($r['due_amount'] ?? 0) > 0 || (int)($r['held_payments'] ?? 0) > 0) ? 'disabled title="لا يمكن الحذف: يوجد مديونيات/تحصيلات معلّقة"' : '' ?>>
                🗑 حذف
              </button>
            </form>
            <!-- CHANGE END -->
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <?php endif; ?>
  </div>

</div>

<!-- Popup إيقاف الموزع -->
<div id="suspendModal" style="display:none;
  position:fixed; inset:0; background:rgba(0,0,0,.35);
  align-items:center; justify-content:center; z-index:9999;">
  <div style="background:#fff; padding:20px 24px; border-radius:10px; width:360px; box-shadow:0 2px 10px rgba(0,0,0,.25);">
    <h3 style="margin-bottom:10px; font-size:1rem;">إيقاف الموزع</h3>
    <p style="font-size:0.85rem; color:#4b5563; margin-bottom:8px;">
      هذا السبب سيظهر لأمين المخزن، ولن يتمكن من صرف منتجات لهذا الموزع.
    </p>
    <form method="post" action="distributor_suspend_toggle.php" id="suspendForm">
      <input type="hidden" name="csrf" value="<?= h($csrf) ?>">
      <input type="hidden" name="id" id="suspend_dist_id" value="">
      <input type="hidden" name="action" value="suspend">

      <textarea name="reason" rows="3" required
        style="width:100%; padding:8px; border-radius:6px; border:1px solid #d1d5db; margin-bottom:10px;"
        placeholder="اكتب سبب الإيقاف هنا..."></textarea>

      <div style="text-align:left;">
        <button type="button" onclick="closeSuspendModal()"
          style="background:#6b7280; color:#fff; border:none; padding:7px 14px; border-radius:6px; margin-left:6px; cursor:pointer;">
          إلغاء
        </button>
        <button type="submit"
          style="background:#b91c1c; color:#fff; border:none; padding:7px 14px; border-radius:6px; cursor:pointer;">
          تأكيد الإيقاف
        </button>
      </div>
    </form>
  </div>
</div>

<!-- مودال إضافة موزع جديد -->
<div id="addModal" class="modal-overlay">
  <div class="modal-dialog">
    <div class="modal-header">
      <span>➕ إضافة موزع جديد</span>
      <button type="button" class="modal-close" onclick="closeAddModal()">✖</button>
    </div>

    <div class="modal-body">
      <?php if ($error): ?>
        <div class="error-msg"><?= h($error) ?></div>
      <?php endif; ?>

      <form method="post">
        <input type="hidden" name="csrf" value="<?= h($csrf) ?>">

        <div class="form-row" style="flex-direction:column; align-items:stretch; gap:12px;">

          <label>
            اسم الموزع
            <input
              type="text"
              name="name"
              placeholder="مثال: أحمد محمد"
              required
              aria-label="اسم الموزع"
            >
          </label>

          <label>
            نوع العمولة
            <select name="comm_type" aria-label="نوع العمولة">
              <option value="PERCENT">نسبة مئوية (%)</option>
              <option value="PER_COPY">مبلغ لكل نسخة</option>
              <option value="NONE">بدون عمولة</option>
            </select>
          </label>

          <label>
            قيمة العمولة
            <input
              type="number"
              name="comm_val"
              step="0.001"
              min="0"
              placeholder="0.000"
              aria-label="قيمة العمولة"
            >
          </label>

          <label>
            اسم الدخول (يوزر)
            <input
              type="text"
              name="username"
              placeholder="مثال: dist1"
              required
              aria-label="اسم الدخول"
            >
          </label>

          <label>
            كلمة المرور
            <input
              type="password"
              name="password"
              placeholder="••••••••"
              required
              aria-label="كلمة المرور"
            >
          </label>

          <button type="submit" class="btn-add" style="width:100%; justify-content:center;">
            ✔ تأكيد الإضافة
          </button>

        </div>
      </form>
    </div>
  </div>
</div>

<script>
function openSuspendModal(id) {
  document.getElementById('suspend_dist_id').value = id;
  document.getElementById('suspendModal').style.display = 'flex';
}
function closeSuspendModal() {
  document.getElementById('suspendModal').style.display = 'none';
}

// مودال إضافة موزع جديد
function openAddModal() {
  document.getElementById('addModal').style.display = 'flex';
}
function closeAddModal() {
  document.getElementById('addModal').style.display = 'none';
}

// إغلاق المودال عند الضغط خارج الصندوق
window.addEventListener('click', function(e) {
  var addModal = document.getElementById('addModal');
  if (e.target === addModal) {
    closeAddModal();
  }
});
</script>

<?php if ($error): ?>
<script>
  // لو في خطأ، افتح المودال تلقائيًا بعد إعادة تحميل الصفحة
  document.addEventListener('DOMContentLoaded', function() {
    openAddModal();
  });
</script>
<?php endif; ?>

</body>
</html>
