<?php
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

require_role(['ADMIN','WAREHOUSE']);

$pdo = db();
$distributor_id = (int)($_GET['distributor_id'] ?? 0);

$from_date = trim((string)($_GET['from'] ?? ''));
$to_date   = trim((string)($_GET['to'] ?? ''));

function _is_ymd($s) {
    if ($s === '') return false;
    $d = DateTime::createFromFormat('Y-m-d', $s);
    return $d && $d->format('Y-m-d') === $s;
}

$dateFilterSqlLedger = '';
$dateFilterSqlDamage = '';
$dateFilterSqlSettlement = '';
$dateFilterSqlDelivery = '';
if (_is_ymd($from_date) && _is_ymd($to_date)) {
    $fromDT = $from_date . ' 00:00:00';
    $toDT   = $to_date   . ' 23:59:59';
    $qFrom  = $pdo->quote($fromDT);
    $qTo    = $pdo->quote($toDT);

    $dateFilterSqlSettlement = " AND os.settlement_at BETWEEN $qFrom AND $qTo ";
    $dateFilterSqlDelivery   = " AND od.delivery_at BETWEEN $qFrom AND $qTo ";
    $dateFilterSqlLedger     = " AND l.created_at BETWEEN $qFrom AND $qTo ";
    $dateFilterSqlDamage     = " AND dr.created_at BETWEEN $qFrom AND $qTo ";
}

$distributors = $pdo->query("SELECT id, name FROM distributors WHERE active=1 ORDER BY name")->fetchAll();

$whereDist = '';
$params    = [];
if ($distributor_id > 0) { $whereDist = 'WHERE d.id = ?'; $params[] = $distributor_id; }

$st = $pdo->prepare("SELECT
        d.id   AS distributor_id,
        d.name AS distributor_name,
        i.id   AS issue_id,
        i.cover_price,
        CONCAT(p.name,' - ',LPAD(i.issue_month,2,'0'),'/',i.issue_year) AS issue_label,

        COALESCE((
            SELECT SUM(l.qty_in)
            FROM inventory_ledger l
            WHERE l.status='POSTED'
              AND l.entity_type='DISTRIBUTOR' AND l.entity_id=d.id
              AND l.issue_id=i.id
              AND l.ref_type IN ('DIST_ORDER','DISPATCH')
        ),0) AS qty_from_warehouse,

	        -- صادر (ODL): الكمية المباعة فعلاً للعملاء
	        -- ملاحظة (MariaDB): لا يمكن عمل UNION داخل Derived Table مع مراجع من الاستعلام الخارجي (d.id / i.id)
	        -- لذلك نحسبها كجمع Subqueries منفصلة.
	        (
	            COALESCE((
	                SELECT SUM(odi.qty_delivered)
	                FROM outlet_delivery_items odi
	                JOIN outlet_deliveries od ON od.id = odi.delivery_id
	                WHERE od.distributor_id = d.id
	                  AND odi.issue_id = i.id
	                  AND od.deal_type = 'DIRECT_SALE'
	                  AND od.status = 'APPROVED'
	                  $dateFilterSqlDelivery
	            ),0)
	            +
	            COALESCE((
	                SELECT SUM(sl.qty_sold)
	                FROM outlet_settlement_lines sl
	                JOIN outlet_settlements os ON os.id = sl.settlement_id
	                WHERE os.distributor_id = d.id
	                  AND sl.issue_id = i.id
	                  AND os.status IN ('SUBMITTED','APPROVED')
	                  $dateFilterSqlSettlement
	            ),0)
	        ) AS qty_sold_to_customers,

        -- تالف معلّق (PENDING) (قيد قرار الأدمن)
        COALESCE((
            SELECT SUM(dr.qty)
            FROM damage_reports dr
            WHERE dr.issue_id=i.id AND dr.distributor_id=d.id
              AND dr.status='PENDING'
              $dateFilterSqlDamage
        ),0) AS qty_damage_pending,

        -- التالف المعتمد/المرفوض من جدول طلبات التالف
        COALESCE((
            SELECT SUM(dr.qty)
            FROM damage_reports dr
            WHERE dr.issue_id=i.id AND dr.distributor_id=d.id
              AND dr.status='APPROVED' $dateFilterSqlDamage
        ),0) AS qty_damage_approved,

        COALESCE((
            SELECT SUM(dr.qty)
            FROM damage_reports dr
            WHERE dr.issue_id=i.id AND dr.distributor_id=d.id
              AND dr.status='REJECTED' $dateFilterSqlDamage
        ),0) AS qty_damage_rejected,

        COALESCE((
            SELECT SUM(l.qty_out)
            FROM inventory_ledger l
            WHERE l.status='POSTED'
              AND l.entity_type='DISTRIBUTOR' AND l.entity_id=d.id
              AND l.issue_id=i.id
              AND l.ref_type IN ('WRT','WH_RETURN') $dateFilterSqlLedger
        ),0) AS qty_returned_to_warehouse,

        COALESCE((
            SELECT v.balance_qty
            FROM v_inventory_balance v
            WHERE v.entity_type='DISTRIBUTOR' AND v.entity_id=d.id AND v.issue_id=i.id
        ),0) AS distributor_balance

    FROM distributors d
    CROSS JOIN issues i
    JOIN products p ON p.id=i.product_id
    $whereDist
    HAVING distributor_balance <> 0
        OR qty_from_warehouse <> 0
        OR qty_sold_to_customers <> 0
        OR qty_damage_pending <> 0
        OR qty_damage_approved <> 0
        OR qty_damage_rejected <> 0
        OR qty_returned_to_warehouse <> 0
    ORDER BY d.name, i.issue_year DESC, i.issue_month DESC, p.name");
$st->execute($params);
$rows = $st->fetchAll();

/* إجماليات */
$grandIn      = array_sum(array_column($rows, 'qty_from_warehouse'));
$grandOut     = array_sum(array_column($rows, 'qty_sold_to_customers'));
$grandDmgPend = array_sum(array_column($rows, 'qty_damage_pending'));
$grandDmgAppr = array_sum(array_column($rows, 'qty_damage_approved'));
$grandDmgRej  = array_sum(array_column($rows, 'qty_damage_rejected'));
$grandBack    = array_sum(array_column($rows, 'qty_returned_to_warehouse'));
$grandBalance = array_sum(array_column($rows, 'distributor_balance'));
// Avoid PHP 7.4+ arrow functions for wider hosting compatibility
$grandValue = 0.0;
foreach ($rows as $r) {
    $grandValue += (int)$r['distributor_balance'] * (float)$r['cover_price'];
}

/* تجميع حسب الموزع لبطاقات الملخص */
$byDist = [];
foreach ($rows as $r) {
    $did = $r['distributor_id'];
    if (!isset($byDist[$did])) {
        $byDist[$did] = ['name' => $r['distributor_name'], 'balance' => 0, 'value' => 0.0];
    }
    $byDist[$did]['balance'] += (int)$r['distributor_balance'];
    $byDist[$did]['value']   += (int)$r['distributor_balance'] * (float)$r['cover_price'];
}


/* ملخص مالي: التحصيل المحاسبي = مجموع (كمية مُباعة × سعر بعد الخصم)
   يشمل البيع المباشر (DIRECT_SALE) + تسويات الأمانة (SUBMITTED/APPROVED).
*/
$moneyParams = [];
$moneyFilterDist = '';
if ($distributor_id > 0) { $moneyFilterDist = ' AND src.distributor_id = ? '; $moneyParams[] = $distributor_id; }

$moneyFilterDateSet = ($dateFilterSqlSettlement !== '') ? $dateFilterSqlSettlement : '';
$moneyFilterDateDel = ($dateFilterSqlDelivery !== '')   ? $dateFilterSqlDelivery   : '';

$moneyByDist = $pdo->prepare("SELECT d.id, d.name, COALESCE(SUM(src.amount),0) AS amount
    FROM (
        SELECT od.distributor_id, odi.issue_id, SUM(odi.qty_delivered * COALESCE(odi.unit_price_applied,0)) AS amount
        FROM outlet_delivery_items odi
        JOIN outlet_deliveries od ON od.id = odi.delivery_id
        WHERE od.deal_type='DIRECT_SALE' AND od.status='APPROVED' $moneyFilterDateDel
        GROUP BY od.distributor_id, odi.issue_id

        UNION ALL

        SELECT os.distributor_id, sl.issue_id, SUM(sl.qty_sold * sl.unit_price_applied) AS amount
        FROM outlet_settlement_lines sl
        JOIN outlet_settlements os ON os.id = sl.settlement_id
        WHERE os.status IN ('SUBMITTED','APPROVED') $moneyFilterDateSet
        GROUP BY os.distributor_id, sl.issue_id
    ) src
    JOIN distributors d ON d.id = src.distributor_id
    WHERE 1=1 $moneyFilterDist
    GROUP BY d.id, d.name
    ORDER BY d.name");
$moneyByDist->execute($moneyParams);
$moneyByDistRows = $moneyByDist->fetchAll();

$moneyByIssue = $pdo->prepare("SELECT i.id AS issue_id,
        CONCAT(p.name,' - ',LPAD(i.issue_month,2,'0'),'/',i.issue_year) AS issue_label,
        COALESCE(SUM(src.amount),0) AS amount
    FROM (
        SELECT od.distributor_id, odi.issue_id, SUM(odi.qty_delivered * COALESCE(odi.unit_price_applied,0)) AS amount
        FROM outlet_delivery_items odi
        JOIN outlet_deliveries od ON od.id = odi.delivery_id
        WHERE od.deal_type='DIRECT_SALE' AND od.status='APPROVED' $moneyFilterDateDel
        GROUP BY od.distributor_id, odi.issue_id

        UNION ALL

        SELECT os.distributor_id, sl.issue_id, SUM(sl.qty_sold * sl.unit_price_applied) AS amount
        FROM outlet_settlement_lines sl
        JOIN outlet_settlements os ON os.id = sl.settlement_id
        WHERE os.status IN ('SUBMITTED','APPROVED') $moneyFilterDateSet
        GROUP BY os.distributor_id, sl.issue_id
    ) src
    JOIN issues i ON i.id = src.issue_id
    JOIN products p ON p.id = i.product_id
    WHERE 1=1 $moneyFilterDist
    GROUP BY i.id, issue_label
    ORDER BY i.issue_year DESC, i.issue_month DESC, p.name");
$moneyByIssue->execute($moneyParams);
$moneyByIssueRows = $moneyByIssue->fetchAll();

$totalCollected = 0.0;
foreach ($moneyByDistRows as $mr) { $totalCollected += (float)$mr['amount']; }
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>عهدة الموزعين — MGZ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<style>
*, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }
body {
    font-family: 'Tajawal', sans-serif;
    background: #f4f7f6;
    color: #333;
    direction: rtl;
    padding: 20px;
    font-size: 14px;
}
a { color: #1a73e8; text-decoration: none; }
a:hover { text-decoration: underline; }
.back-link { margin-bottom: 14px; display: inline-block; font-size: .9rem; }
.page-header {
    background: linear-gradient(135deg, #e65100, #f57c00);
    color: #fff;
    padding: 18px 24px;
    border-radius: 10px;
    margin-bottom: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 10px;
}
.page-header h2 { font-size: 1.3rem; font-weight: 700; margin-bottom: 2px; }
.page-header small { opacity: .85; font-size: .85rem; }
.card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    margin-bottom: 20px;
    overflow: hidden;
}
.card-header {
    padding: 14px 20px;
    border-bottom: 1px solid #eee;
    font-weight: 700;
    font-size: .95rem;
    background: #fafafa;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.card-body { padding: 20px; }
.filter-grid {
    display: grid;
    grid-template-columns: 1.6fr 1fr 1fr auto;
    gap: 14px;
    align-items: end;
}
.form-group label {
    display: block;
    font-weight: 600;
    color: #555;
    margin-bottom: 5px;
    font-size: .85rem;
}
select, input[type=text] {
    width: 100%;
    padding: 8px 10px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: .9rem;
    font-family: inherit;
    background: #fff;
}
select:focus, input:focus {
    outline: none;
    border-color: #f57c00;
    box-shadow: 0 0 0 3px rgba(245,124,0,.1);
}
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px,1fr));
    gap: 14px;
    margin-bottom: 20px;
}
.stat-card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    text-align: center;
    padding: 16px 10px;
    border-top: 4px solid transparent;
}
.stat-card.blue   { border-color: #1a73e8; }
.stat-card.green  { border-color: #34a853; }
.stat-card.orange { border-color: #f57c00; }
.stat-card.red    { border-color: #ea4335; }
.stat-card.purple { border-color: #6f42c1; }
.stat-card .num   { font-size: 1.5rem; font-weight: 700; }
.stat-card .lbl   { color: #888; font-size: .82rem; margin-top: 4px; }
.stat-card.blue   .num { color: #1a73e8; }
.stat-card.green  .num { color: #34a853; }
.stat-card.orange .num { color: #f57c00; }
.stat-card.red    .num { color: #ea4335; }
.stat-card.purple .num { color: #6f42c1; }

/* بطاقات ملخص الموزعين */
.dist-summary-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px,1fr));
    gap: 12px;
    margin-bottom: 20px;
}
.dist-card {
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,.08);
    padding: 16px;
    border-right: 4px solid #f57c00;
}
.dist-card .dist-name { font-weight: 700; font-size: .95rem; margin-bottom: 8px; color: #333; }
.dist-card .dist-balance { font-size: 1.4rem; font-weight: 700; color: #f57c00; }
.dist-card .dist-value { font-size: .85rem; color: #888; margin-top: 2px; }

.table-wrap { overflow-x: auto; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 10px 14px; border-bottom: 1px solid #eee; text-align: right; white-space: nowrap; }
th { background: #f8f9fa; font-weight: 600; color: #555; font-size: .85rem; }
tr:last-child td { border-bottom: none; }
tbody tr:hover td { background: #fffbf0; }
.total-row td { font-weight: 700; background: #fff3e0; }
.dist-group-row td {
    background: #fff8e1;
    font-weight: 700;
    color: #e65100;
    font-size: .88rem;
    padding: 6px 14px;
}
.btn {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    padding: 7px 16px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: .88rem;
    font-family: inherit;
    font-weight: 600;
    text-decoration: none;
    transition: opacity .15s;
}
.btn:hover { opacity: .88; }
.btn-outline { background: transparent; border: 1px solid #ccc; color: #555; }
.btn-primary { background: #f57c00; color: #fff; }
.btn-sm { padding: 4px 10px; font-size: .8rem; }
.money       { font-weight: 700; color: #1a73e8; }
.money-green { font-weight: 700; color: #34a853; }
.money-red   { font-weight: 700; color: #ea4335; }
.money-orange{ font-weight: 700; color: #f57c00; }
.badge-ok   { background: #e6f4ea; color: #1e7e34; padding: 2px 10px; border-radius: 12px; font-size: .78rem; font-weight: 700; }
.badge-warn { background: #fff8e1; color: #f57c00; padding: 2px 10px; border-radius: 12px; font-size: .78rem; font-weight: 700; }
.badge-zero { background: #fce8e6; color: #c62828; padding: 2px 10px; border-radius: 12px; font-size: .78rem; font-weight: 700; }
.empty-state { text-align: center; padding: 50px 20px; color: #aaa; }
.empty-state .icon { font-size: 3rem; margin-bottom: 10px; }
.search-bar { padding: 14px 20px; border-bottom: 1px solid #eee; background: #fafafa; }
.search-bar input {
    width: 100%; max-width: 380px;
    padding: 8px 12px; border: 1px solid #ddd;
    border-radius: 6px; font-size: .9rem; font-family: inherit;
}
.search-bar input:focus {
    outline: none; border-color: #f57c00;
    box-shadow: 0 0 0 3px rgba(245,124,0,.1);
}
@media print {
    .no-print { display: none !important; }
    body { background: #fff; padding: 0; }
    .card { box-shadow: none; border: 1px solid #ddd; }
}
@media (max-width: 768px) {
    body { padding: 12px; }
    .stats-grid { grid-template-columns: repeat(2,1fr); }
    th, td { padding: 8px; font-size: .82rem; }
    .filter-grid { grid-template-columns: 1fr; }
}
</style>

<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="../assets/ui.css">
<script defer src="../assets/ui.js"></script>
</head>
<body>

<a href="../dashboard.php" class="back-link no-print">&#8594; العودة للرئيسية</a>

<!-- Page Header -->
<div class="page-header no-print">
    <div>
        <h2>&#128666; عهدة الموزعين</h2>
        <small>رصيد كل موزع من الإصدارات — <?= date('d/m/Y H:i') ?></small>
    </div>
    <button class="btn btn-outline"
            style="background:rgba(255,255,255,.2);color:#fff;border-color:rgba(255,255,255,.4);"
            onclick="window.print()">
        &#128424; طباعة
    </button>
</div>

<!-- فلتر -->
<div class="card no-print">
    <div class="card-header">&#128269; فلتر التقرير</div>
    <div class="card-body">
        <form method="get">
            <div class="filter-grid">
                <div class="form-group">
                    <label>الموزع</label>
                    <select name="distributor_id">
                        <option value="0">— جميع الموزعين —</option>
                        <?php foreach ($distributors as $d): ?>
                        <option value="<?= (int)$d['id'] ?>"
                            <?= $distributor_id === (int)$d['id'] ? 'selected' : '' ?>>
                            <?= h($d['name']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>من تاريخ</label>
                    <input type="date" name="from" value="<?= h($from_date) ?>">
                </div>
                <div class="form-group">
                    <label>إلى تاريخ</label>
                    <input type="date" name="to" value="<?= h($to_date) ?>">
                </div>
<div class="form-group">
                    <label>&nbsp;</label>
                    <button type="submit" class="btn btn-primary" style="width:100%;">
                        &#128269; عرض
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- إحصائيات -->
<div class="stats-grid no-print">
    <div class="stat-card blue">
        <div class="num"><?= count($byDist) ?></div>
        <div class="lbl">عدد الموزعين</div>
    </div>
    <div class="stat-card orange">
        <div class="num"><?= fmt_int($grandIn) ?></div>
        <div class="lbl">إجمالي الوارد (DIS)</div>
    </div>
    <div class="stat-card green">
        <div class="num"><?= fmt_int($grandOut) ?></div>
        <div class="lbl">إجمالي الموزّع (ODL)</div>
    </div>
    <div class="stat-card purple">
        <div class="num"><?= fmt_int($grandBack) ?></div>
        <div class="lbl">إجمالي المرتجع (WRT)</div>
    </div>
    <div class="stat-card <?= $grandBalance > 0 ? 'orange' : 'green' ?>">
        <div class="num"><?= fmt_int($grandBalance) ?></div>
        <div class="lbl">إجمالي العهدة</div>
    </div>
    <div class="stat-card blue">
        <div class="num" style="font-size:1.1rem;"><?= omr($grandValue) ?></div>
        <div class="lbl">القيمة الإجمالية (ر.ع.)</div>
    </div>
</div>

<!-- بطاقات ملخص الموزعين -->
<?php if (!empty($byDist)): ?>
<div class="dist-summary-grid no-print">
    <?php foreach ($byDist as $did => $ds): ?>
    <div class="dist-card">
        <div class="dist-name">&#128666; <?= h($ds['name']) ?></div>
        <div class="dist-balance"><?= fmt_int($ds['balance']) ?> نسخة</div>
        <div class="dist-value"><?= omr($ds['value']) ?></div>
    </div>
    <?php endforeach; ?>
</div>
<?php endif; ?>

<!-- عنوان الطباعة -->
<div style="display:none;" id="printHeader">
    <h2 style="text-align:center;margin-bottom:4px;">تقرير عهدة الموزعين</h2>
    <p style="text-align:center;color:#888;font-size:.85rem;margin-bottom:16px;">
        <?= $distributor_id > 0
            ? h(array_column($distributors,'name','id')[$distributor_id] ?? '')
            : 'جميع الموزعين' ?>
        — تاريخ الطباعة: <?= date('d/m/Y H:i') ?>
    </p>
</div>

<!-- الجدول التفصيلي -->
<div class="card">
    <div class="card-header">
        التفاصيل حسب الموزع والإصدار
        <span style="font-weight:400;font-size:.85rem;color:#888;"><?= count($rows) ?> سطر</span>
    </div>

    <div class="search-bar no-print">
        <input type="text"
               id="searchInput"
               placeholder="&#128269; بحث باسم الموزع أو الإصدار..."
               oninput="filterTable()">
    </div>

    <div class="table-wrap">
        <table id="holdingsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الموزع</th>
                    <th>الإصدار</th>
                    <th>سعر الغلاف</th>
                    <th>وارد (DIS)</th>
                    <th>صادر (ODL)</th>
                    <th>تالف معلّق</th>
                    <th>تالف معتمد</th>
                    <th>تالف مرفوض</th>
                    <th>مرتجع للمخزن (WRT)</th>
                    <th>الرصيد</th>
                    <th>القيمة (ر.ع.)</th>
                    <th>الحالة</th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($rows)): ?>
                <tr><td colspan="13">
                    <div class="empty-state">
                        <div class="icon">&#128666;</div>
                        <div>لا توجد بيانات عهدة</div>
                    </div>
                </td></tr>
            <?php else: ?>
                <?php
                $prevDist = null;
                $distIdx  = 0;
                foreach ($rows as $idx => $r):
                    $bal   = (int)$r['distributor_balance'];
                    $value = $bal * (float)$r['cover_price'];
                    if ($bal <= 0)       { $bc = 'badge-zero'; $bt = 'نفذ'; }
                    elseif ($bal < 5)    { $bc = 'badge-warn'; $bt = 'منخفض'; }
                    else                 { $bc = 'badge-ok';   $bt = 'بعهدته'; }

                    /* فاصل الموزع */
                    if ($r['distributor_id'] !== $prevDist):
                        $prevDist = $r['distributor_id'];
                        $distIdx++;
                ?>
                <tr class="dist-group-row">
                    <td colspan="13">
                        &#128666; <?= h($r['distributor_name']) ?>
                        &nbsp;&nbsp;
                        <span style="font-weight:400;font-size:.82rem;color:#888;">
                            إجمالي العهدة:
                            <?= fmt_int($byDist[$r['distributor_id']]['balance']) ?> نسخة |
                            <?= omr($byDist[$r['distributor_id']]['value']) ?>
                        </span>
                    </td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td><?= $idx + 1 ?></td>
                    <td><?= h($r['distributor_name']) ?></td>
                    <td><?= h($r['issue_label']) ?></td>
                    <td><?= omr((float)$r['cover_price']) ?></td>
                    <td style="color:#34a853;font-weight:600;"><?= fmt_int((int)$r['qty_from_warehouse']) ?></td>
                    <td style="color:#1a73e8;font-weight:600;"><?= fmt_int((int)$r['qty_sold_to_customers']) ?></td>
                    <td style="color:#f57c00;font-weight:600;"><?= fmt_int((int)$r['qty_damage_pending']) ?></td>
                    <td style="color:#34a853;font-weight:600;"><?= fmt_int((int)$r['qty_damage_approved']) ?></td>
                    <td style="color:#ea4335;font-weight:600;"><?= fmt_int((int)$r['qty_damage_rejected']) ?></td>
                    <td style="color:#6f42c1;font-weight:600;"><?= fmt_int((int)$r['qty_returned_to_warehouse']) ?></td>
                    <td class="money-orange" style="font-size:1rem;"><?= fmt_int($bal) ?></td>
                    <td class="money"><?= omr($value) ?></td>
                    <td><span class="<?= $bc ?>"><?= $bt ?></span></td>
                </tr>
                <?php endforeach; ?>
                <tr class="total-row">
                    <td colspan="4" style="text-align:left;">الإجمالي الكلي</td>
                    <td style="color:#34a853;"><?= fmt_int($grandIn) ?></td>
                    <td style="color:#1a73e8;"><?= fmt_int($grandOut) ?></td>
                    <td style="color:#f57c00;"><?= fmt_int($grandDmgPend) ?></td>
                    <td style="color:#34a853;"><?= fmt_int($grandDmgAppr) ?></td>
                    <td style="color:#ea4335;"><?= fmt_int($grandDmgRej) ?></td>
                    <td style="color:#6f42c1;"><?= fmt_int($grandBack) ?></td>
                    <td class="money-orange"><?= fmt_int($grandBalance) ?></td>
                    <td class="money"><?= omr($grandValue) ?></td>
                    <td></td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>


<div class="card no-print" style="margin-top:20px;">
    <div class="card-header">&#128176; الملخص المالي (حسب الفترة)</div>
    <div class="card-body">
        <div style="margin-bottom:10px;color:#666;font-size:.9rem;">
            <?php if (_is_ymd($from_date) && _is_ymd($to_date)): ?>
                الفترة: <?= h($from_date) ?> إلى <?= h($to_date) ?>
            <?php else: ?>
                الفترة: من البداية (حدد من/إلى للحصول على ملخص لفترة محددة)
            <?php endif; ?>
        </div>

        <div class="stats-grid" style="margin-bottom:10px;">
            <div class="stat-card green">
                <div class="num" style="font-size:1.1rem;"><?= omr($totalCollected) ?></div>
                <div class="lbl">إجمالي المحصل (ر.ع.)</div>
            </div>
        </div>

        <div style="display:grid;grid-template-columns:1fr 1fr;gap:14px;">
            <div class="card" style="box-shadow:none;border:1px solid #eee;">
                <div class="card-header" style="background:#fafafa;border-bottom:1px solid #eee;">إجمالي محصل حسب الموزع</div>
                <div class="card-body" style="padding:12px;">
                    <div class="table-wrap" style="box-shadow:none;border:1px solid #f0f0f0;">
                        <table>
                            <thead>
                                <tr><th>الموزع</th><th>إجمالي المحصل (ر.ع.)</th></tr>
                            </thead>
                            <tbody>
                            <?php if (empty($moneyByDistRows)): ?>
                                <tr><td colspan="2" style="text-align:center;color:#888;">لا توجد بيانات</td></tr>
                            <?php else: foreach ($moneyByDistRows as $mr): ?>
                                <tr>
                                    <td><?= h($mr['name']) ?></td>
                                    <td class="money"><?= omr((float)$mr['amount']) ?></td>
                                </tr>
                            <?php endforeach; endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card" style="box-shadow:none;border:1px solid #eee;">
                <div class="card-header" style="background:#fafafa;border-bottom:1px solid #eee;">إجمالي محصل حسب الإصدار</div>
                <div class="card-body" style="padding:12px;">
                    <div class="table-wrap" style="box-shadow:none;border:1px solid #f0f0f0;">
                        <table>
                            <thead>
                                <tr><th>الإصدار</th><th>إجمالي المحصل (ر.ع.)</th></tr>
                            </thead>
                            <tbody>
                            <?php if (empty($moneyByIssueRows)): ?>
                                <tr><td colspan="2" style="text-align:center;color:#888;">لا توجد بيانات</td></tr>
                            <?php else: foreach ($moneyByIssueRows as $mr): ?>
                                <tr>
                                    <td><?= h($mr['issue_label']) ?></td>
                                    <td class="money"><?= omr((float)$mr['amount']) ?></td>
                                </tr>
                            <?php endforeach; endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-top:10px;color:#888;font-size:.85rem;">
            * التحصيل المحاسبي = مجموع (تحصيل عدد × السعر بعد الخصم) من تسويات الأمانة المعتمدة.
        </div>
    </div>
</div>

</div>

<script>
function filterTable() {
    var input = document.getElementById('searchInput').value.toLowerCase();
    var rows  = document.querySelectorAll('#holdingsTable tbody tr:not(.dist-group-row):not(.total-row)');
    rows.forEach(function(row) {
        row.style.display = row.textContent.toLowerCase().includes(input) ? '' : 'none';
    });
}
</script>

<style>
@media print {
    #printHeader { display: block !important; }
    .no-print    { display: none !important; }
}
</style>

</body>
</html>
