<?php
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

require_role(['ADMIN']);

$pdo = db();

function _parse_date_input($s) {
  $s = trim((string)$s);
  if ($s === '') return null;
  foreach (['Y-m-d', 'm/d/Y', 'd/m/Y'] as $fmt) {
    $d = DateTime::createFromFormat($fmt, $s);
    if ($d && $d->format($fmt) === $s) return $d;
  }
  return null;
}

$from_raw = $_GET['from'] ?? '';
$to_raw   = $_GET['to'] ?? '';

$from_d = _parse_date_input($from_raw);
$to_d   = _parse_date_input($to_raw);

$from_dt = $from_d ? ($from_d->format('Y-m-d') . ' 00:00:00') : null;
$to_dt   = $to_d   ? ($to_d->format('Y-m-d')   . ' 23:59:59') : null;

$from_date = $from_d ? $from_d->format('Y-m-d') : '';
$to_date   = $to_d   ? $to_d->format('Y-m-d')   : '';

function fmt3($n) { return number_format((float)$n, 3, '.', ''); }
function fmt_omr($n) {
  $n = (float)$n;
  // trim trailing zeros
  $s = number_format($n, 3, '.', '');
  $s = rtrim(rtrim($s, '0'), '.');
  return $s === '' ? '0' : $s;
}

$distributor_id = (int)($_GET['distributor_id'] ?? 0);
$outlet_id = (int)($_GET['outlet_id'] ?? 0);

// dropdown data
$distributors = $pdo->query("SELECT id, name FROM distributors ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$outlets = $pdo->query("SELECT id, name FROM outlets ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

$where = "p.status <> 'VOID' AND p.distributor_id IS NOT NULL AND p.outlet_id IS NOT NULL";
$params = [];

if ($distributor_id > 0) { $where .= " AND p.distributor_id = ?"; $params[] = $distributor_id; }
if ($outlet_id > 0)      { $where .= " AND p.outlet_id = ?";      $params[] = $outlet_id; }

if ($from_dt) { $where .= " AND p.paid_at >= ?"; $params[] = $from_dt; }
if ($to_dt)   { $where .= " AND p.paid_at <= ?"; $params[] = $to_dt; }

// Totals (overall)
$sql_tot = "SELECT
  COALESCE(SUM(CASE WHEN p.status IN ('HELD','POSTED') THEN p.amount ELSE 0 END),0) AS collected_outlets,
  COALESCE(SUM(CASE WHEN p.status = 'POSTED' THEN p.amount ELSE 0 END),0) AS posted_office
FROM payments p
WHERE $where";
$st = $pdo->prepare($sql_tot);
$st->execute($params);
$tot = $st->fetch(PDO::FETCH_ASSOC);
$tot_collected = (float)$tot['collected_outlets'];
$tot_posted = (float)$tot['posted_office'];
$tot_diff = $tot_collected - $tot_posted;

// Group by distributor
$sql_by_dist = "SELECT
  d.id,
  d.name,
  COALESCE(SUM(CASE WHEN p.status IN ('HELD','POSTED') THEN p.amount ELSE 0 END),0) AS collected_outlets,
  COALESCE(SUM(CASE WHEN p.status = 'POSTED' THEN p.amount ELSE 0 END),0) AS posted_office
FROM payments p
JOIN distributors d ON d.id = p.distributor_id
WHERE $where
GROUP BY d.id, d.name
ORDER BY d.name";
$st = $pdo->prepare($sql_by_dist);
$st->execute($params);
$rows_dist = $st->fetchAll(PDO::FETCH_ASSOC);

// Group by issue? not requested. Group by outlet (optional) for detail:
$where_o = $where;
$params_o = $params;
$sql_by_outlet = "SELECT
  o.id,
  o.name,
  COALESCE(SUM(CASE WHEN p.status IN ('HELD','POSTED') THEN p.amount ELSE 0 END),0) AS collected_outlets,
  COALESCE(SUM(CASE WHEN p.status = 'POSTED' THEN p.amount ELSE 0 END),0) AS posted_office
FROM payments p
JOIN outlets o ON o.id = p.outlet_id
WHERE $where_o
GROUP BY o.id, o.name
ORDER BY o.name";
$st = $pdo->prepare($sql_by_outlet);
$st->execute($params_o);
$rows_out = $st->fetchAll(PDO::FETCH_ASSOC);

$now = (new DateTime('now'))->format('d/m/Y H:i');
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>تحصيلات الموزعين للمكتب — MGZ</title>
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="../assets/ui.css">
<script defer src="../assets/ui.js"></script>
<style>
  body{font-family:'Tajawal',sans-serif;background:#f4f7f6;color:#222;padding:18px}
  .page-header{background:linear-gradient(135deg,#0d6efd,#6610f2);color:#fff;padding:18px 22px;border-radius:12px;margin-bottom:16px;display:flex;justify-content:space-between;align-items:center;gap:10px;flex-wrap:wrap}
  .page-header h2{margin:0;font-size:1.2rem}
  .card{background:#fff;border-radius:12px;box-shadow:0 2px 8px rgba(0,0,0,.08);margin-bottom:16px;overflow:hidden}
  .card-header{padding:12px 16px;border-bottom:1px solid #eee;font-weight:700;background:#fafafa}
  .card-body{padding:16px}
  .filter-grid{display:grid;grid-template-columns:2fr 2fr 1fr 1fr auto;gap:12px;align-items:end}
  label{display:block;font-size:.85rem;color:#555;margin-bottom:6px;font-weight:600}
  input[type=date],select{width:100%;padding:8px 10px;border:1px solid #ddd;border-radius:8px;background:#fff}
  .btn{display:inline-flex;align-items:center;gap:6px;padding:8px 14px;border-radius:8px;border:0;cursor:pointer;font-weight:700}
  .btn-primary{background:#0d6efd;color:#fff}
  .btn-outline{background:#fff;border:1px solid #ddd;color:#333}
  .stats{display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:12px}
  .stat{background:#fff;border-radius:12px;box-shadow:0 2px 8px rgba(0,0,0,.08);padding:14px;text-align:center;border-top:4px solid #0d6efd}
  .stat .num{font-size:1.4rem;font-weight:800}
  .stat .lbl{color:#777;margin-top:4px;font-size:.85rem}
  table{width:100%;border-collapse:collapse}
  th,td{padding:10px 12px;border-bottom:1px solid #eee;white-space:nowrap;text-align:right}
  th{background:#f8f9fa;font-size:.85rem;color:#555}
  .money{font-weight:800}
  .muted{color:#777;font-size:.85rem}
  @media(max-width:860px){.filter-grid{grid-template-columns:1fr}}
</style>
</head>
<body>
<a href="../dashboard.php" class="back-link no-print">&#8594; العودة للرئيسية</a>

<div class="page-header">
  <div>
    <h2>💰 تحصيلات الموزعين للمكتب</h2>
    <small>ملخص التحصيل — <?= h($now) ?></small>
  </div>
  <div class="muted">المحصّل من المنافذ = HELD + POSTED • المعتمد بالمكتب = POSTED</div>
</div>

<div class="card no-print">
  <div class="card-header">🔍 فلتر التقرير</div>
  <div class="card-body">
    <form method="get">
      <div class="filter-grid">
        <div>
          <label>الموزع</label>
          <select name="distributor_id">
            <option value="0">— جميع الموزعين —</option>
            <?php foreach($distributors as $d): ?>
              <option value="<?= (int)$d['id'] ?>" <?= $distributor_id==(int)$d['id']?'selected':'' ?>><?= h($d['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label>المنفذ</label>
          <select name="outlet_id">
            <option value="0">— جميع المنافذ —</option>
            <?php foreach($outlets as $o): ?>
              <option value="<?= (int)$o['id'] ?>" <?= $outlet_id==(int)$o['id']?'selected':'' ?>><?= h($o['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label>من تاريخ</label>
          <input type="date" name="from" value="<?= h($from_date) ?>">
        </div>
        <div>
          <label>إلى تاريخ</label>
          <input type="date" name="to" value="<?= h($to_date) ?>">
        </div>
        <div style="display:flex;gap:8px;align-items:end">
          <button class="btn btn-primary" type="submit">تطبيق</button>
          <a class="btn btn-outline" href="report_office_collections.php">مسح</a>
        </div>
      </div>
    </form>
  </div>
</div>

<div class="stats">
  <div class="stat" style="border-top-color:#1a73e8">
    <div class="num money"><?= fmt_omr($tot_collected) ?> ر.ع</div>
    <div class="lbl">إجمالي محصل من المنافذ</div>
  </div>
  <div class="stat" style="border-top-color:#34a853">
    <div class="num money"><?= fmt_omr($tot_posted) ?> ر.ع</div>
    <div class="lbl">إجمالي مُعتمد بالمكتب</div>
  </div>
  <div class="stat" style="border-top-color:#ea4335">
    <div class="num money"><?= fmt_omr($tot_diff) ?> ر.ع</div>
    <div class="lbl">فرق (مع الموزعين لم يُسلَّم بعد)</div>
  </div>
</div>

<div class="card">
  <div class="card-header">📌 إجمالي التحصيل حسب الموزع</div>
  <div class="card-body">
    <div style="overflow:auto">
      <table>
        <thead>
          <tr>
            <th>الموزع</th>
            <th>محصل من المنافذ</th>
            <th>معتمد بالمكتب</th>
            <th>الفرق</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows_dist): ?>
            <tr><td colspan="4" class="muted">لا توجد بيانات</td></tr>
          <?php else: ?>
            <?php foreach($rows_dist as $r): 
              $c=(float)$r['collected_outlets']; $p=(float)$r['posted_office']; $df=$c-$p; ?>
              <tr>
                <td><?= h($r['name']) ?></td>
                <td class="money"><?= fmt_omr($c) ?> ر.ع</td>
                <td class="money"><?= fmt_omr($p) ?> ر.ع</td>
                <td class="money"><?= fmt_omr($df) ?> ر.ع</td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header">🏪 إجمالي التحصيل حسب المنفذ (ضمن الفلتر)</div>
  <div class="card-body">
    <div style="overflow:auto">
      <table>
        <thead>
          <tr>
            <th>المنفذ</th>
            <th>محصل من المنفذ</th>
            <th>معتمد بالمكتب</th>
            <th>الفرق</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!$rows_out): ?>
            <tr><td colspan="4" class="muted">لا توجد بيانات</td></tr>
          <?php else: ?>
            <?php foreach($rows_out as $r): 
              $c=(float)$r['collected_outlets']; $p=(float)$r['posted_office']; $df=$c-$p; ?>
              <tr>
                <td><?= h($r['name']) ?></td>
                <td class="money"><?= fmt_omr($c) ?> ر.ع</td>
                <td class="money"><?= fmt_omr($p) ?> ر.ع</td>
                <td class="money"><?= fmt_omr($df) ?> ر.ع</td>
              </tr>
            <?php endforeach; ?>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

</body>
</html>
